﻿define(['common/Enums', 'common/Error', 'common/GeometryNormalizer/Processor/PathCommands/PathSyntaxCommand',
  'common/GeometryNormalizer/Processor/PathSyntaxCommandElement'],
    function (Enums, Error, PathSyntaxCommand, PathSyntaxCommandElement) {
        var SmoothBezierCurveCommand = PathSyntaxCommand.extend({

            parse: function (args) {
                var tempArray = this._splitPath(args),
                    i,
                    argsCount = this._getArgsCount();

                for (i = 0; i < tempArray.length - (argsCount - 1) ; i += argsCount) {
                    var c1x = new PathSyntaxCommandElement(Enums.pathSyntaxCommandElementType.X, tempArray[i]);
                    var c1y = new PathSyntaxCommandElement(Enums.pathSyntaxCommandElementType.Y, tempArray[i + 1]);
                    var c2x = new PathSyntaxCommandElement(Enums.pathSyntaxCommandElementType.X, tempArray[i + 2]);
                    var c2y = new PathSyntaxCommandElement(Enums.pathSyntaxCommandElementType.Y, tempArray[i + 3]);

                    this.elements.push(c1x);
                    this.elements.push(c1y);
                    this.elements.push(c2x);
                    this.elements.push(c2y);
                }
            },

            getPattern: function () {
                return ' {0},{1} {2},{3} ';
            },

            getCommand: function () {
                return Enums.pathCommand.S;
            }
        });

        return SmoothBezierCurveCommand;
    });