﻿// <copyright file="SliderModel.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// 

/*
* @class SliderModel model class for Slider control
*/

define(['common/Enums', 'base/RangeControlModel'],
function (Enums, RangeControlModel) {
    //here we will define model for button


    var SliderModel = RangeControlModel.extend({

        init: function (type, parentResourceManager) {
            this._super(type, parentResourceManager);

            this.ClassName = 'SliderModel';
        },

        getSliderRelativeSize: function () {
            if (this.getOrientation() === Enums.OrientationType.Horizontal) {
                return 100 * this.get(Enums.ParameterRoles.SLIDER_SIZE) / this.get(Enums.ParameterRoles.WIDTH);
            } else {
                return 100 * this.get(Enums.ParameterRoles.SLIDER_SIZE) / this.get(Enums.ParameterRoles.HEIGHT);
            }
        }
    });

    return SliderModel;
});
