﻿// <copyright file="scheme.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// 

define(['controls/Scheme/SchemeControl', 'core/ModulesProvider', 'controls/Scheme/SchemePreloader', 'core/global/GlobalSettingsType'],
    function (schemeControl, ModulesProvider, SchemePreloader, GlobalSettings) {
	//will be used to build scheme

	var Scheme = Class.extend({

	    init: function () {
	        ModulesProvider.subscribeProviderReady(this.buildScheme.bind(this), this);
	        ModulesProvider.loadModules();
	    },

	    buildScheme: function () {
	        document.title = GlobalSettings.ProjectName.value;
	        SchemePreloader.allowHide(false);
	        console.log('Scheme created');	       
	        this.container = schemeControl();
	        this.render();
	        SchemePreloader.allowHide(true);
	        SchemePreloader.hide();
	    },

		render: function () {
			$$.document.append(this.container);
		},

	});

	return Scheme;
});