﻿// <copyright file="Server.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// 


define(['helpers/XhrWrapper', 'core/Statistic'], function (helper, Statistic) {

    function Server() {      
        this.initialized = false;
    };

    var exceptions = ['GetLoginData', 'Login', 'Logout'];

    Server.prototype.init = function (prefix) {

        this.prefix = prefix || '';
        this.initialized = true;
    }

    Server.prototype.sendQuery = function (command, parameters, url) {       

        if (!this.initialized && exceptions.indexOf(command) < 0) {
            return Promise.reject(new Error("Server not inialized"));
        } else {
            var statisticId = Statistic.startMeasurement(command);
            if (!url)
                url = "";
            return helper.loadUrl(
                url+this.prefix +'/Methods/' + command,
                "POST",
                typeof parameters == 'string' ? parameters : JSON.stringify(parameters)).
                then(function (response) {
                    response.data.url = url;
                    Statistic.stopMeasurement(statisticId);
                    return { status: response.status, data: response.data, command: command, parameters: parameters};
                }, function (response) {
                    response.data.queryType = command;                    
                    Statistic.cancelMeasurement(statisticId);
                    return Promise.reject({ status: response.status, data: response.data, command: command, parameters: parameters });
                });
        }
    }

    var instance = new Server();

    return instance;
});