﻿// <copyright file="DataAdapterErrorProcessor.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// 


define(['common/Enums', 'core/L10n'], function (enums, L10n) {
    var stateVars = enums.serverState;

    function DataAdapterErrorProcessor(serverStateManager) {
        this.retryInterval = 2000;
        this.missedFrames = 0;
        this.retryCount = 0;
        this.tryingReconnect = false;
        this.restarting = false;        
        this.manager = serverStateManager;
    }

    DataAdapterErrorProcessor.prototype.resetErrorStatus = function (command) {
        if (this.manager.get(stateVars.Connected) == false) {
            this.manager.set(stateVars.connectionError, false);
            this.manager.set(stateVars.Connected, true);
            if (this.tryingReconnect == true) {
                this.retryCount = 0;
                this.tryingReconnect = false;
                $(".outer").remove();
                location.reload();
            }
            if (this.restarting == true) {
                this.restarting = false;
                setTimeout(this.finishRestart.bind(this), 1500);
            }  
        }
        return;
    };

    DataAdapterErrorProcessor.prototype.handleDisconnect = function (missedFrames) {
        if ($(".outer").length == 0) {
            this.createHolder(L10n.get("messages.disconnect"));
        }
        return L10n.get("messages.wasDisconnected") + missedFrames;
    };

    DataAdapterErrorProcessor.prototype.handleServerError = function (result) {
        var serverData;
        try {
            serverData = typeof result.data == 'string' ? $.parseJSON(result.data) : result.data;
        } catch (err) {
            serverData = {
                code: 0,
                message: "Invalid JSON responce from server.",
                queryType: result.command
            }
        }
        var code = serverData.code;
        var errorString = "";

        if (code == 0 && result.status == 0) { //условия дисконнекта
            this.missedFrames++;
            if (this.tryingReconnect == false && this.retryCount < 3) {
                this.tryingReconnect = true;
                setTimeout(this.tryReconnect.bind(this), this.retryInterval);
            }
            if (this.retryCount == 3) {
                this.tryingReconnect = true;
                this.manager.set(stateVars.Connected, false);
                this.manager.set(stateVars.connectionError, true);
                errorString = this.handleDisconnect(this.missedFrames);
            }
        }

        if (code != 0 && result.status != 0) { //условия ошибки 
            switch (code) {
                case 0x80560000:
                    this.createHolder("Достигнуто максимальное число подключенных клиентов"); //opcTooManySessions
                    break;
                case 2155151360: 
                case -2139815936:
                    errorString = L10n.get("messages.unknownCommand") + result.command; //0x80750000 - метод запроса не опознан
                    break;
                case 200:
                case 0x00A60000:
                    break;
                case 2148204544:  //0x800B0000 - поддержка визуализации не доступна
                case 0x80320000:
                case 0x802A0000:
                case 0x80840000:
                case 0x804A0000:
                case 0x80D20000:
                    errorString = L10n.get("opcErrors." + code);
                    break;    
                case 2148270080:  
                case -2146697216: //0x800C0000 - код рестарта                
                    this.handleRestart();
                    break;
                case 2150105088: //0x80280000 - передан недействительный код подписки
                case 2149908480:
                case -2145058816: //0x80250000 - передан некорректный SessionId
                    this.finishRestart();
                    break;
                default:
                    errorString = L10n.get("opcErrors." + code);
                    if (this.restarting == true && (result.status == 200 || result.status == 500)) {
                        this.restarting = false;
                        setTimeout(this.finishRestart.bind(this), 1500);
                    }  
            }
        }
        if (result.data && result.data.message)
            errorString += " " + result.data.message;
        console.warn(errorString);
        return errorString;
    };

    DataAdapterErrorProcessor.prototype.handleRestart = function () {
        if (this.restarting == false) {
            this.restarting = true;

            if ($(".outer").length == 0) {
                this.createHolder(L10n.get("messages.restart"));
            }
            return 'Restarted';
        }
        return "";
    };

    DataAdapterErrorProcessor.prototype.finishRestart = function () {
        $(".outer").remove();
        location.reload();
        this.restarting = false;
    };

    DataAdapterErrorProcessor.prototype.tryReconnect = function () {
        this.retryCount++;
        this.tryingReconnect = false;
    };

    DataAdapterErrorProcessor.prototype.createHolder = function (holderText) {
        var message = document.createElement('div');
        message.className = "outer";
        message.style.top = "0px";
        message.style.left = "0px";
        message.style.width = "100%";
        message.style.height = "100%";
        message.style.position = "absolute";
        message.innerHTML = '<div class="login">\
                        <span>' + holderText + '</span>\
                    </div>';
        document.body.appendChild(message);
    };

    return DataAdapterErrorProcessor;
});