﻿// <copyright file="ContainerModel.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// 

/*
* @class ContainerModel
* Base class for model os container controls (like window and panels)
*/
define(['base/ControlModel', 'core/ResourceManager'], function (ControlModel, ResourceManager) {

    var CHILDREN_ADDED_EVENT = 'children added';

    var ContainerModel = ControlModel.extend({

        init: function (type, parentResourceManager) {
            this._super(type, parentResourceManager);
            this.attachedProperties = {};
            for (var i = 0; i < type.attachedProperties.length; i++) {
                this.attachedProperties[type.attachedProperties[i].role] = type.attachedProperties[i].defaultValue;
            }
        },

        initModel: function (model, context, attachedProperties) {
            this._super(model, undefined, attachedProperties);
            if (model && model.childModels) {
                this.childModels = model.childModels;
                this.fireOnChildrenAdded(model.childModels, context)
            }
        },

        subscribeOnChildrenAdded: function (handler, context) {
            this.eventTarget.addListener(CHILDREN_ADDED_EVENT, handler, context);
        },

        unsubscribeOnChildrenAdded: function (handler) {
            this.eventTarget.removeListener(CHILDREN_ADDED_EVENT, handler);
        },

        fireOnChildrenAdded: function (childModels, context) {
            this.eventTarget.fire({
                type: CHILDREN_ADDED_EVENT,
                target: this,
                childModels: childModels,
                context: context
            });
        }
    });

    return ContainerModel;
});