﻿define(['common/Enums', 'common/Error', 'common/GeometryNormalizer/Processor/PathCommands/PathSyntaxCommand',
    'common/GeometryNormalizer/Processor/PathSyntaxCommandElement'],
    function (Enums, Error, PathSyntaxCommand, PathSyntaxCommandElement) {
        var ArcCommand = PathSyntaxCommand.extend({
            init: function (type) {
                this._super(type);
            },

            parse: function (args) {
                var tempArray = this._splitPath(args),
                    i,
                    argsCount = this._getArgsCount();

                for (i = 0; i < tempArray.length - (argsCount - 1) ; i += argsCount) {
                    var sizeX = new PathSyntaxCommandElement(Enums.pathSyntaxCommandElementType.Width, tempArray[i]);
                    var sizeY = new PathSyntaxCommandElement(Enums.pathSyntaxCommandElementType.Height, tempArray[i + 1]);
                    var angle = new PathSyntaxCommandElement(Enums.pathSyntaxCommandElementType.Setting, tempArray[i + 2]);
                    var largeFlag = new PathSyntaxCommandElement(Enums.pathSyntaxCommandElementType.Setting, tempArray[i + 3]);
                    var sweepFlag = new PathSyntaxCommandElement(Enums.pathSyntaxCommandElementType.Setting, tempArray[i + 4]);
                    var x = new PathSyntaxCommandElement(Enums.pathSyntaxCommandElementType.X, tempArray[i + 5]);
                    var y = new PathSyntaxCommandElement(Enums.pathSyntaxCommandElementType.Y, tempArray[i + 6]);

                    this.elements.push(sizeX);
                    this.elements.push(sizeY);
                    this.elements.push(angle);
                    this.elements.push(largeFlag);
                    this.elements.push(sweepFlag);
                    this.elements.push(x);
                    this.elements.push(y);
                }
            },

            getPattern: function () {
                return ' {0},{1} {2} {3} {4} {5},{6} ';
            },

            getCommand: function () {
                return Enums.pathCommand.A;
            }
        });

        return ArcCommand;
    });