﻿// <copyright file="Utilites.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// 

define(['common/Enums', 'common/Error'], function (Enums, Error) {

    var Utilites = {};

    Utilites.lowerCaseRegx = /[a-z]/;

    var appearances;
    curl(['common/Appearence']).then(function (app) {
        appearances = app;
    });


    Utilites.getMeasureSuffix = function (measureUnit) {
        switch (measureUnit) {
            case Enums.SizeType.Relative:
                return '%';
            case Enums.SizeType.Pixel:
                return 'px';
            case Enums.SizeType.INCHES:
                return 'in';
            case Enums.SizeType.POINTS:
                return 'pt';
            default:
                Error.warn(String.format('Unknown size units {0} Pixels will be used.', measureUnit));
                return 'px';
        }
    };
    Utilites.isJSON = function (value) {
        return (!(/[^,:{}\[\]0-9.\-+Eaeflnr-u \n\r\t]/.test(value.replace(/"(\\.|[^"\\])*"/g, ''))));
    },
    Utilites.isPercents = function (value) {
        if (!value) {
            return false;
        }

        return value.slice(-1) === '%';
    };

    Utilites.isEnumValue = function (enum1, value) {

        for (prop in enum1) {
            if (enum1.hasOwnProperty(prop) && enum1[prop] === value) {
                return true;
            }
        }

        return false;
    };

    Utilites.removeArrayItem = function (array, value) {
        if (array === undefined) {
            return;
        }
        if (array.indexOf(value) != -1) { // Make sure the value exists
            return array.splice(array.indexOf(value), 1);
        }
    }

    Utilites.removeArrayItems = function (array, items) {
        if (!(array instanceof Array) || !(items instanceof Array)) {
            return;
        }
        if (array === undefined || items === undefined) {
            return;
        }
        for (var i = 0, k = items.length; i < k; ++i) {
            removeArrayItem(array, items[i]);
        }
    }


    Utilites.isDigit = function (char) {
        var myCharCode = char.charCodeAt(0);

        if ((myCharCode > 47) && (myCharCode < 58)) {
            return true;
        }

        return false;
    };

    Utilites.countOccurences = function (text, re) {
        var counter = 0;
        while (re.test(text)) {
            counter++;
        }

        return;
    };


    //TODO привести к согласию эту и следующую
    //Эта используется в Set/Get Property
    //следуящая в проверки параметра триггера
    Utilites.compareValues = function (v1, v2) {
        if (typeof v1 !== typeof v2) {
            return false;
        }

        if (v1 instanceof Date && v2 instanceof Date) {
            return v1.valueOf() === v2.valueOf();
        }
        else {
            return v1 === v2; //TODO тут числа сравнятся не по значению, а как строки
        }
    };

    Utilites.equal = function (prop1, prop2) {
        if (prop1.typeName != prop2.typeName) {
            return false;
        }

        return Utilites.compare(prop1.value, prop2.value) === 0;
    }
    Utilites.compare = function (value1, value2) {
        if ((value1 === undefined && value2 !== undefined) || 
            (value1 === null && value2 !== null)) {
            return -1;
        } else if ((value2 === undefined && value1 !== undefined) ||
            (value2 === null && value1 !== null)) {
            return 1;
        }

        var compareFunc = function (a, b) {
            return a < b ? -1 : a > b ? 1 : 0;
        };

        switch (typeof (value1)) {
            case "number":
                return compareFunc(parseFloat(value1), parseFloat(value2));
            case "date":
                return compareFunc(new Date(value1), new Date(value2));
            case "boolean":
                return (value1 === value2) ? 0 : value1 ? -1 : 1;
            case "string": {
                if (value1.length !== value2.length) {
                    return compareFunc(value1.length, value2.length);
                } else {
                    return value1.localeCompare(value2);
                }
            };
            case "object":
                if (JSON.stringify(value1) === JSON.stringify(value2))
                    return 0;
                else
                    return 1;
            default:
                Error.onerror("Cannot compare " + value1 + " and " + value2 + " : type '" + typeof (value1) + "' is unknown");
                break;
        }
    };


    Utilites.GetIntervalPercentValue = function (val, min, max) {
        var valN = Number(val);
        var minN = Number(min);
        var maxN = Number(max);
        var res = ((valN - minN) / (maxN - minN));
        return Math.min(100, Math.max(0, res));
    };

    Utilites.GetIntervalValue = function (percent, min, max) {
        var percentN = Number(percent);
        var minN = Number(min);
        var maxN = Number(max);
        return (((maxN - minN)) * percentN + minN);
    };

    //Gets midlle color between two colors. Min, Max- int numbers or color string in format #AARRGGBB, #RRGGBB
    Utilites.getMiddleColor = function (min, max, percent) {

        var startColor = appearances.color.ARGBtoObj(min);
        var endColor = appearances.color.ARGBtoObj(max);
        //(A1-(A1-B1)/h*x, A2-(A2-B2)/h*x, A3-(A3-B3)/h*x)
        var A = Math.ceil(startColor.a - (startColor.a - endColor.a) * percent);
        var R = Math.ceil(startColor.r - (startColor.r - endColor.r) * percent);
        var G = Math.ceil(startColor.g - (startColor.g - endColor.g) * percent);
        var B = Math.ceil(startColor.b - (startColor.b - endColor.b) * percent);
        return appearances.color.objToCSS({ a: A, r: R, g: G, b: B });
    };

    Utilites.STTypeToJsType = function (type) {
        switch (type) {
            case Enums.serverType.byte:
            case Enums.serverType.int:
            case Enums.serverType.dint:
            case Enums.serverType.lint:
            case Enums.serverType.sint:
            case Enums.serverType.uint:
            case Enums.serverType.udint:
            case Enums.serverType.ulint:
            case Enums.serverType.usint:
            case Enums.serverType.real:
            case Enums.serverType.lreal:
            case Enums.serverType.word:
            case Enums.serverType.dword:
            case Enums.serverType.lword:
            case Enums.serverType.time:
                return Enums.parameterType.number;
            case Enums.serverType.date:
            case Enums.serverType.date_and_time:
            case Enums.serverType.dt:
            case Enums.serverType.tod:
                return Enums.parameterType.date;
            case Enums.serverType.bool:
                return Enums.parameterType.boolean;
            case Enums.serverType.color:
            case Enums.serverType.gradient:
                return Enums.parameterType.color;
            default:
                return Enums.parameterType.string;
        }
    };

    Utilites.getValueByType = function (value, type) {
        if (typeof (value) === "string") {
            switch (type) {
                case Enums.parameterType.number:
                    return parseFloat(value);
                case Enums.parameterType.date:
                    return new Date(value);
                case Enums.parameterType.boolean:
                    return value.toLowerCase() == 'true';
                case Enums.parameterType.color:
                case Enums.serverType.gradient:
                    return value;
                default:
                    return value;
            }
        } else {
            return value;
        }
    }

    Utilites.calculate = function (currentValue, newValue, operation) {
        switch (operation) {
            case Enums.operation.move:
                currentValue = newValue;
                break;
            case Enums.operation.add:
                currentValue += newValue;
                break;
            case Enums.operation.subtract:
                currentValue -= newValue;
                break;
            case Enums.operation.multiply:
                currentValue *= newValue;
                break;
            case Enums.operation.divide:
                currentValue /= newValue;
                break;
            case Enums.operation.concat:
                currentValue = currentValue.toString() + newValue.toString();
                break;
            default:
                currentValue = newValue;
                break;
        }

        return currentValue;
    }

    Utilites.isWebkit = function () {
        return window.PrefixFree.prefix.indexOf(Enums.BrowserPrefix.WebKit) >= 0 ||
               (window.PrefixFree.prefix.indexOf(Enums.BrowserPrefix.Opera) >= 0
                    && window.PrefixFree.prefix.length === 3);
    }

    Utilites.isSafari = function () {        
        return Object.prototype.toString.call(window.HTMLElement).indexOf('Constructor') > 0;
    },

    Utilites.isIE = function () {
        return (window.PrefixFree.prefix.indexOf(Enums.BrowserPrefix.MS) >= 0) ||
               (window.PrefixFree.prefix.indexOf(Enums.BrowserPrefix.IE) >= 0);
    }

    Utilites.isTablet = function () {
        if (/Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent)) {
            return true;
        }

        return false;
    }

    Utilites.padLeft = function (str, count, char) {
        return Array(count).join(char) + str;
    }

    Utilites.isNumber = function (value) {
        return !isNaN(parseInt(value, 10));
    }

    Utilites.isLowerCase = function (str) {
        return (Utilites.lowerCaseRegx.test(str));
    }

    Utilites.stringifyObj = function (obj) {
        if (obj === undefined) {
            return 'undefined';
        }

        if (obj === null) {
            return 'null';
        }

        if (obj instanceof Object) {
            return JSON.stringify(obj);
        }

        return obj;
    }

    Utilites.copyAttributes = function (src, dest) {
        var attributes = src.prop("attributes");
        for (var i = 0; i < attributes.length; ++i) {
            dest.attr(attributes[i].name, attributes[i].value);
        }

        dest.val(src.val());

        var events = $._data(src[0], 'events');

        if (events == undefined) {
            return;
        }

        // Iterate through all event types
        $.each(events, function (eventType, eventArray) {
            // Iterate through every bound handler
            $.each(eventArray, function (index, event) {
                // Take event namespaces into account
                var eventToBind = event.namespace.length > 0
                    ? (event.type + '.' + event.namespace)
                    : (event.type);

                // Bind event
                dest.bind(eventToBind, event.data, event.handler);
            });
        });
    }

    Utilites.forceRedraw = function (element) {
        var disp = element.style.display;
        element.style.display = 'none';
        var trick = element.offsetHeight;
        element.style.display = disp;
    }
    Utilites.precision = function(a) {
        if (!isFinite(a)) return 0;
        var e = 1, p = 0;
        while (Math.round(a * e) / e !== a) { e *= 10; p++; }
        return p;
    }

    Utilites.decimalAdjust = function (value, exp) {
        value = +value;
        exp = +exp;
        // Если значение не является числом, либо степень не является целым числом...
        if (isNaN(value) || !(typeof exp === 'number' && exp % 1 === 0)) {
            return NaN;
        }
        // Сдвиг разрядов
        value = value.toString().split('e');
        value = Math.round(+(value[0] + 'e' + (value[1] ? (+value[1] - exp) : -exp)));
        // Обратный сдвиг
        value = value.toString().split('e');
        return +(value[0] + 'e' + (value[1] ? (+value[1] + exp) : exp));
    }

    Utilites.dateToUtc = function (dt) {
        return new Date(dt.getTime() + (dt.getTimezoneOffset() * 60000));
    }
    Utilites.timeToUtc = function (t) {
        var offset = (new Date()).getTimezoneOffset();
        return (t + 60000 * offset);
    }
    Utilites.timeToLocal = function (t) {
        var offset = (new Date()).getTimezoneOffset();
        return (t - 60000 * offset);
    }

    Utilites.convertMsToArray = function (ms) {
        var d, h, m, s, f;
        f = ms % 1000;
        s = Math.floor(ms / 1000);
        m = Math.floor(s / 60);
        s = s % 60;
        h = Math.floor(m / 60);
        m = m % 60;
        d = Math.floor(h / 24);
        h = h % 24;
        return [d, h, m, s, f];
    };
    Utilites.parseTime = function (val, format) {
        this.isInteger = function (val) {
            for (var i = 0; i < val.length; i++) {
                if ("1234567890".indexOf(val.charAt(i)) == -1) {
                    return false;
                }
            }
            return true;
        };
        this.getInt = function (str, i, minlength, maxlength) {
            for (var x = maxlength; x >= minlength; x--) {
                var token = str.substring(i, i + x);
                if (token.length < minlength) {
                    return null;
                }
                if (this.isInteger(token)) {
                    return token;
                }
            }
            return null;
        };
        var time = 0;
        val = val + "";
        format = format + "";
        var i_val = 0;
        var i_format = 0;
        var c = "";
        var token = "";
        var date = 1;
        var hh = 0;
        var mm = 0;
        var ss = 0;
        while (i_format < format.length) {
            // Get next token from format string
            c = format.charAt(i_format);
            token = "";
            while ((format.charAt(i_format) == c) && (i_format < format.length)) {
                token += format.charAt(i_format++);
            }
            if (token == "dd" || token == "d") {
                date = this.getInt(val, i_val, token.length, 10);
                if (date == null || (date < 0)) {
                    return null;
                }
                time = time+date * 24 * 60 * 60 * 1000;
                i_val += date.length;
            }
            else if (token == "HH" || token == "H") {
                hh = this.getInt(val, i_val, token.length, 2);
                if (hh == null || (hh < 0) || (hh > 23)) {
                    return null;
                }
                time = time + hh * 60 * 60 * 1000;
                i_val += hh.length;
            }
            else if (token == "mm" || token == "m") {
                mm = this.getInt(val, i_val, token.length, 2);
                if (mm == null || (mm < 0) || (mm > 59)) {
                    return null;
                }
                time = time + mm * 60 * 1000;
                i_val += mm.length;
            }
            else if (token == "ss" || token == "s") {
                ss = this.getInt(val, i_val, token.length, 2);
                if (ss == null || (ss < 0) || (ss > 59)) {
                    return null;
                }
                time = time + ss * 1000;
                i_val += ss.length;
            }
            else {
                if (val.substring(i_val, i_val + token.length) != token) {
                    return null;
                }
                else {
                    i_val += token.length;
                }
            }
        }
        if (i_val != val.length) {
            return null;
        }
        return time;
    };
    Utilites._addLeadingZeros = function (num) {
        if (num < 10) {
            return '00' + num;
        }
        if (num < 100) {
            return '0' + num;
        }
        return num.toString();
    };
    Utilites.formatTimeToString = function (time, format) {
        format = format + "";
        var result = "";
        var i_format = 0;
        var c = "";
        var token = "";
        var d, H, m, s, f;
        f = time % 1000;
        s = Math.floor(time / 1000);
        m = Math.floor(s / 60);
        s = s % 60;
        H = Math.floor(m / 60);
        m = m % 60;
        d = Math.floor(H / 24);
        H = H % 24;
        if (format.indexOf('d') == -1) {
            H += d * 24;
            if (format.indexOf('H') == -1) {
                m += H * 60;
                if (format.indexOf('m') == -1) {
                    s += m * 60;
                    if (format.indexOf('s') == -1) {
                        f += s * 1000;
                    }
                }
            }
        }
        var value = new Object();
        value["d"] = d
        value["dd"] = Date.LZ(d);
        value["H"] = H;
        value["HH"] = Date.LZ(H);
        value["f"] = Utilites._addLeadingZeros(f).charAt(0);
        value["ff"] = Utilites._addLeadingZeros(f).substr(0, 2);
        value["fff"] = Utilites._addLeadingZeros(f);
        value["m"] = m;
        value["mm"] = Date.LZ(m);
        value["s"] = s;
        value["ss"] = Date.LZ(s);
        while (i_format < format.length) {
            c = format.charAt(i_format);
            token = "";
            while ((format.charAt(i_format) == c) && (i_format < format.length)) {
                token += format.charAt(i_format++);
            }
            if (typeof (value[token]) != "undefined") {
                result = result + value[token];
            }
            else {
                result = result + token;
            }
        }
        return result;
    };


    Utilites.hasServerVariables = function (serverVariables) {
        return serverVariables
             && (
            this.hasGetServerVariables(serverVariables)
                 ||
            this.hasSetServerVariables(serverVariables)
            );
    }

    Utilites.hasGetServerVariables = function (serverVariables) {
        return serverVariables
             && (serverVariables.hasOwnProperty('getValues') && serverVariables.getValues.length > 0)
    }

    Utilites.hasSetServerVariables = function (serverVariables) {
        return serverVariables
           && (serverVariables.hasOwnProperty('setValues') && serverVariables.setValues.length > 0);

    }

    Utilites.escapeChartersForRegExp = function (str) {
        return str.replace('/', '\\/');
        //replace('\\', '\\\\').replace('[', '\\[').replace(']', '\\]')
    }

    Utilites.buildFullPath = function (endpoint) {
        var fullPath = '';
        switch (endpoint.type) {
            case Enums.connectionType.server:
                fullPath = endpoint.context + '/' + endpoint.path + '/' +  endpoint.itemId + '/' + endpoint.propertyPath;
                break;
            default:
                fullPath = endpoint.context + '/' + endpoint.path + '/' + endpoint.propertyPath;
                break;
        }        
        //для согласования с buildPath из ControlController
        fullPath = fullPath.replace(/[\/]{1,}/gi, "/");

        return fullPath;
    };

    Utilites.locationOf = function (element, field, array, start, end) {
        start = start || 0;
        end = end || array.length;
        var pivot = parseInt(start + (end - start) / 2, 10);
        if (end - start <= 1 || array[pivot][field] === element[field]) {
            return pivot;
        }
        if (array[pivot][field] < element[field]) {
            return this.locationOf(element, field, array, pivot, end);
        } else {
            return this.locationOf(element, field, array, start, pivot);
        }
    };

    return Utilites;
});
