﻿// <copyright file="GaugeController.js" company="ИнСАТ">
// ИнСАТ, 2016
// </copyright>

define(['common/Enums', 'common/Error', 'common/Appearence', 'base/ControlController'],
function (Enums, Error, Appearence, RangeControlController) {
    //here we will define controller for Slider

    var SliderController = RangeControlController.extend({

        init: function () {
            this._super();
            this.ClassName = 'GaugeController';
            this.initialized = false;
            this.modelChanged[Enums.ParameterRoles.VALUE] = this.onValueChanged.bind(this);
            this.modelChanged[Enums.ParameterRoles.INTERVALS_NUMBER] = this.onScaleChanged.bind(this);
            this.modelChanged[Enums.ParameterRoles.INTERVAL_TICKS_NUMBER] = this.onScaleChanged.bind(this);
            this.modelChanged[Enums.ParameterRoles.SCALE_COLOR] = this.onScaleChanged.bind(this);
            this.modelChanged[Enums.ParameterRoles.MIN_VALUE] = this.onMinValueChanged.bind(this);
            this.modelChanged[Enums.ParameterRoles.MAX_VALUE] = this.onMaxValueChanged.bind(this);
            this.modelChanged[Enums.ParameterRoles.PRECISION] = this.onPrecisionChanged.bind(this);
            this.modelChanged[Enums.ParameterRoles.UNIT] = this.onUnitChanged.bind(this);
            this.modelChanged[Enums.ParameterRoles.SHOW_VALUE] = this.onSvgModelChanged.bind(this, Enums.ParameterRoles.SHOW_VALUE + ":display", Appearence.getDisplay);
            this.modelChanged[Enums.ParameterRoles.ARROW_COLOR] = this.onSvgModelChanged.bind(this, Enums.ParameterRoles.ARROW_COLOR + ":values", Appearence.color.color2Matrix);
            this.modelChanged[Enums.ParameterRoles.TEXT_COLOR] = this.onSvgModelChanged.bind(this, "Text:fill", null);
            this.modelChanged[Enums.ParameterRoles.FONT_SIZE] = this.onSvgModelChanged.bind(this, "Text:font-size", null);
            this.modelChanged[Enums.ParameterRoles.FONT_NAME] = this.onSvgModelChanged.bind(this, "Text:font-family", null);
            this.modelChanged[Enums.ParameterRoles.FONT_ITALIC] = this.onSvgModelChanged.bind(this, "Text:font-style", Appearence.text.getTextItalic);
            this.modelChanged[Enums.ParameterRoles.FONT_BOLD] = this.onSvgModelChanged.bind(this, "Text:font-weight", Appearence.text.getTextBold);
            this.modelChanged[Enums.ParameterRoles.FONT_UNDERLINED] = this.onSvgModelChanged.bind(this, "Text:text-decoration", Appearence.text.getTextUnderline);
        },
        drawLine: function (point1, point2) {
            var newLine = document.createElementNS('http://www.w3.org/2000/svg', 'line');
            newLine.setAttribute('id', "line"+this.line_id);
            newLine.setAttribute('x1', point1.x);
            newLine.setAttribute('y1', point1.y);
            newLine.setAttribute('x2', point2.x);
            newLine.setAttribute('y2', point2.y);
            newLine.setAttribute('style', 'stroke: ' + this.mvc.model.get(Enums.ParameterRoles.SCALE_COLOR) + ';stroke-width:2');
            this.line_id++;
            $(this._getScale()).append(newLine);
        },
        drawText: function(point, text){
            var newText = document.createElementNS('http://www.w3.org/2000/svg', 'text');
            newText.setAttribute('id', "label"+this.text_id);
            newText.setAttribute('x', point.x);
            newText.setAttribute('y', point.y);
            newText.setAttribute('font-size', 10);
            newText.setAttribute('text-anchor', 'middle');
            newText.setAttribute('fill', this.mvc.model.get(Enums.ParameterRoles.SCALE_COLOR));
            newText.textContent = text;
            this.text_id++;
            $(this._getScale()).append(newText);
        },
        onAddedToDOM: function () {
            if (!this.mvc.model.get(Enums.ParameterRoles.SKIN)) {
                Error.warn(String.format("У стрелочного прибора {0} не задан образ. Контрол работать не будет", this.mvc.model.getId()));
                return;
            }
            this._super();
            this.initialized = true;
        },
        modelPropertyChangedInternal: function(event){
            if (this.initialized && this.loaded) {
                this._super(event);
            }
        },
        onMinValueChanged: function (value) {
            this.onMinMaxChanged(value);
        },
        onIsVisibleChanged: function (value) {
            if (!value) {
                this.mvc.view.$().css('visibility', 'hidden');
                return;
            }
            this.mvc.view.$().css('visibility', 'visible');
        },

        onMaxValueChanged: function (value) {
            this.onMinMaxChanged(value);
        },
        getCurrentValue: function (value) {
            var val = parseFloat(this.mvc.model.get(Enums.ParameterRoles.VALUE));
            if (val == null || isNaN(val) || !isFinite(val)) {
                val = this.mvc.model.getMinValue();
            }
            return val;
        },
        onScaleChanged: function (value) {
            $(this._getScale()).empty();
            if (this.mvc.model.get(Enums.ParameterRoles.INTERVALS_NUMBER) > 0) {
                var radius = this._getRadius();
                this.color = 0xFF0000;
                var length = this._getLength();
                this.line_id = 0;
                this.text_id = 0;
                var minAngle = this._getMinAngle();
                var maxAngle = this._getMaxAngle();
                var angle_step = (maxAngle - minAngle) / this.mvc.model.get(Enums.ParameterRoles.INTERVALS_NUMBER);
                var inner_angle_step = angle_step / this.mvc.model.get(Enums.ParameterRoles.INTERVAL_TICKS_NUMBER);
                var value_step = (this.mvc.model.get(Enums.ParameterRoles.MAX_VALUE) - this.mvc.model.get(Enums.ParameterRoles.MIN_VALUE)) / this.mvc.model.get(Enums.ParameterRoles.INTERVALS_NUMBER);
                if (!this.rotate_x || !this.rotate_y) {
                    transform = Appearence.parseRotate(this._getArrow().getAttribute("transform"));
                    this.rotate_x = transform.x;
                    this.rotate_y = transform.y;
                }
                for (var i = 0; i <= this.mvc.model.get(Enums.ParameterRoles.INTERVALS_NUMBER) ; i++) {
                    var angle = (i * angle_step + minAngle + 90) * (Math.PI / 180);
                    this.drawLine({ x: this.calculateScaleX(radius, angle), y: this.calculateScaleY(radius, angle) },
                                  { x: this.calculateScaleX(radius + length, angle), y: this.calculateScaleY(radius + length, angle) });
                    this.drawText({ x: this.calculateScaleX(radius - 8, angle), y: this.calculateScaleY(radius - 8, angle) }, this.toFixedOrLess(this.mvc.model.get(Enums.ParameterRoles.MIN_VALUE) + value_step * i, this.mvc.model.get(Enums.ParameterRoles.PRECISION)));
                    if (i < this.mvc.model.get(Enums.ParameterRoles.INTERVALS_NUMBER)) {
                        for (var j = 1; j < this.mvc.model.get(Enums.ParameterRoles.INTERVAL_TICKS_NUMBER) ; j++) {
                            var inner_angle = angle + (j * inner_angle_step * Math.PI / 180);
                            this.drawLine({ x: this.calculateScaleX(radius + length / 2, inner_angle), y: this.calculateScaleY(radius + length / 2, inner_angle) },
                                          { x: this.calculateScaleX(radius + length, inner_angle), y: this.calculateScaleY(radius + length, inner_angle) });
                        }
                    }
                }
            }
        },
        calculateScaleX: function(r, u){
            return this.rotate_x + r * Math.cos(u);
        },
        calculateScaleY: function (r, u) {
            return this.rotate_y + r * Math.sin(u);
        },
        toFixedOrLess: function(value, precision) {
            var fixed = value.toFixed(precision);
            var as_is = value.toString();
            return as_is.length < fixed.length ? as_is : parseFloat(fixed);
        },
        onPrecisionChanged: function(value){
            if (this.mvc.model.get(Enums.ParameterRoles.PRECISION)<0){
                Error.warn(String.format("У контрола {0} {1} выставлена недопустимая точность {2}. Значение сбрасывается по умолчанию в 0", this.mvc.model.getId(), this.mvc.model.getRole(), this.mvc.model.get(Enums.ParameterRoles.PRECISION)));
                this.mvc.model.set(Enums.ParameterRoles.PRECISION, 0);
            }
            this.onMinMaxChanged();
        },
        onMinMaxChanged: function(value){
            this.onScaleChanged();
            this.onValueChanged(this.mvc.model.get(Enums.ParameterRoles.VALUE));
        },
        onValueChanged: function (value) {
            if (!this.initialized || (this.mvc.model.get(Enums.ParameterRoles.MAX_VALUE) - this.mvc.model.get(Enums.ParameterRoles.MIN_VALUE) <= 0)) {
                return;
            }
            if (value < this.mvc.model.get(Enums.ParameterRoles.MIN_VALUE)) {
                value = this.mvc.model.get(Enums.ParameterRoles.MIN_VALUE);
            } else if (value > this.mvc.model.get(Enums.ParameterRoles.MAX_VALUE)) {
                value = this.mvc.model.get(Enums.ParameterRoles.MAX_VALUE);
            }
            var k = (this._getMaxAngle() - this._getMinAngle()) / Math.abs(this.mvc.model.get(Enums.ParameterRoles.MAX_VALUE) - this.mvc.model.get(Enums.ParameterRoles.MIN_VALUE));
            var angle = (value - this.mvc.model.get(Enums.ParameterRoles.MIN_VALUE)) * k;
            var transform = {};
            if (!this.rotate_x || !this.rotate_y) {
                transform = Appearence.parseRotate(this._getArrow().getAttribute("transform"));
                this.rotate_x = transform.x;
                this.rotate_y = transform.y;
            }
            transform.x = this.rotate_x;
            transform.y = this.rotate_y;
            transform.angle = Math.floor(angle);
            this._getArrow().setAttribute('transform', Appearence.formatRotate(transform));
            this.onUnitChanged();
        },
        onUnitChanged: function(value){
            this.onSvgModelChanged(Enums.ParameterRoles.TEXT + ":Content", null, this.toFixedOrLess(this.mvc.model.get(Enums.ParameterRoles.VALUE), this.mvc.model.get(Enums.ParameterRoles.PRECISION)) + this.mvc.model.get(Enums.ParameterRoles.UNIT));
        },
        _getArrow: function () {
            return this.getSVGElementById('arrow');
        },
        _getBody: function(){
            return this.getSVGElementById('body');
        },
        _getValue: function(){
            return this.getSVGElementById('field');
        },
        _getMaxAngle: function(){
            return parseInt(this.getSVGAttributeFromElement(this._getArrow(), "max-angle"));
        },
        _getMinAngle: function(){
            return parseInt(this.getSVGAttributeFromElement(this._getArrow(), "min-angle"));
        },
        _getScale: function(){
            return this.getSVGElementById('scale');
        },
        _getRadius: function () { //радиус, расстояние от центра на котором будут находиться засечки
            return parseInt(this.getSVGAttributeFromElement(this._getScale(), "radius"));
        },
        _getLength: function () { //длина засечек
            return parseInt(this.getSVGAttributeFromElement(this._getScale(), "length"));
        }
    });
    return SliderController;
});
