﻿// <copyright file="GeometryModel.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// 

define(['common/Enums', 'base/ContainerModel', 'common/GeometryNormalizer/GeometryNormalizer'],
function (Enums, ContainerModel, GeometryNormalizer) {
    var GeometryModel = ContainerModel.extend({

        init: function (type, parentResourceManager) {
            this._super(type, parentResourceManager);

            this.ClassName = 'GeometryModel';

        },

        getGeometry: function (parentWidth, parentHeight) {
            var geomOrgigin = this.get('BorderGeometryOrigin');
            var editorGeom = this.get(Enums.ParameterRoles.BORDER_GEOMETRY);
            var elementId = this.getId();
            var geometry = GeometryNormalizer.normalize(this.get(Enums.ParameterRoles.BORDER_GEOMETRY),
                this.get(Enums.ParameterRoles.WIDTH),
                this.get(Enums.ParameterRoles.HEIGHT),
                parentWidth, parentHeight);

            //if (geometry !== geomOrgigin) {
            //    console.debug(String.format('Possible error in geometry ({0}).'+
            //        '\n Editor value "{1}"; \n Translator value: "{2}" \n RT value: "{3}"',
            //        elementId, editorGeom, geomOrgigin, geometry));
            //}

            return geometry;
        },
    });

    return GeometryModel;
});