﻿// <copyright file="Detail.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// 

define(['controls/Journal/modules/GridHelper',
     'common/Enums',
     'helpers/PathBuilder',
      'common/Appearence',
      'controls/Journal/modules/details/DetailModel'
], function (helper, Enums, PathBuilder,  Appearence, DetailModel) {
    var placeholder = 'tbody';

    var detailsProto = $$({
        _model: {},
        view: {
            format: '<tr><td><span data-bind="DisplayName"></span><span data-bind="value"></span></td></tr>',
        },

        setValue: function (propertyName, value) {
            var obj = {};
            obj[propertyName] = value;
            this._model.set(obj);

            if (propertyName === Enums.ParameterRoles.VISIBILITY) {
                this.updateVisibility();
            }
        },

        updateVisibility: function () {
            var value = this._model.get(Enums.ParameterRoles.VISIBILITY);
            this.view.$().css('display', value ? '' : 'none');
        }
    });

    var Detail = Class.extend({
        init: function (journalModel, id) {
            this.id = id;
            this.model = new DetailModel(id, journalModel);
            this.model.subscribePropertyChanged(this.onModelPropertyChanged, this);
            this.detail = null;
            this._createDetail();
        },

        _createDetail: function () {
            this.detail = $$(detailsProto, {
                _model: {
                    Field: this.model.getField(),
                    DisplayName: this.model.getDisplayName(),
                    Visibility: this.model.getVisibility(),
                    value: ''
                }
            });

            this.detail.updateVisibility();
        },

        render: function (container) {
            container.find(placeholder).append(this.detail.view.$());
        },

        onModelPropertyChanged: function (event) {
            var pathArray = new PathBuilder(event.property).getArray();
            if (pathArray[0] === Enums.ParameterRoles.LEGEND_COLUMNS &&
                pathArray[1] === this.id.toString()) {
                this.detail.setValue(pathArray[2], this.model.get(pathArray[2]));
            }
        },

        setMessage: function(message){
            var field = this.model.getField();
            this.detail.setValue('value', String.format(this.model.getValueFormat(), message[field]));
        },

        clearValue: function () {
            this.detail.setValue('value', '');
        },

        showMessage: function (message) {
            if (!this.shown) {
                return;
            }

            this.Details._model.set(helper.formatMessage(message, this.settings.fields), { reset: true });
            this.Details.view.sync();

        },

        changeVisibility: function () {
            if (this.shown === false) {
                this.show();
            } else {
                this.hide();
            }
        },

        show: function () {

            var root = this.Details.view.$();
            root.css({ display: '' });
            root = null;
            this.shown = true;
            return this.Details.view.$().height();
        },
        hide: function () {
            var height = -this.Details.view.$().height();
            var root = this.Details.view.$();
            root.css({ display: 'none' });
            root = null;
            this.shown = false;
            return height;
        }
    });

    return Detail;
});