﻿// <copyright file="LabelModel.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// 

/*
* @class LabelModel model class for Label control
*/
define(['common/Enums', 'base/TextControlModel'],
function (Enums, TextControlModel) {
    //here we will define model for button

    var LabelModel = TextControlModel.extend({

        init: function (type, parentResourceManager) {
            this._super(type, parentResourceManager);
            this.ClassName = 'LabelModel';
        },

        getValueFormat: function () {
            return this.get(Enums.ParameterRoles.VALUE_FORMAT);
        },

        getDisplayValue: function () {
            var text = this.getText();
            var format = this.getValueFormat();

            var displayText;

            if (format) {
                displayText = String.format(format, text);
            }
            else {
                displayText = text;
            }

            return displayText;
        },

        getTextShadowColor: function () {
            return this.get(Enums.ParameterRoles.SHADOW_COLOR);
        },

        getTextShadowSize: function () {
            return this.get(Enums.ParameterRoles.SHADOW_SIZE);
        },
    });

    return LabelModel;
});
