﻿// <copyright file="ControlController.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// 

define(['common/Enums', 'common/Appearence', 'base/BooleanControlController'],
function (Enums, Appearence, BooleanControlController) {

    var RadioButtonController = BooleanControlController.extend({

        init: function () {
            this._super();
            this.ClassName = 'RadioButtonController';
            this.modelChanged[Enums.ParameterRoles.IS_CHECKED] = this.onIsCheckedChanged.bind(this);
            this.modelChanged[Enums.ParameterRoles.TEXT_COLOR] = this.onTextColorChanged.bind(this);
        },

        renderOverflow: function () {
            this.mvc.view.$().css('overflow', 'visible');
        },

        onCornerRadiusChanged: function (value) {
            this._super(value);            
        },

        onIsCheckedChanged: function (value) {

            var parent,
                role,
                id,
                child;
            if (this.mvc.model.get(Enums.ParameterRoles.SKIN)) {
                this.onSvgIsCheckedChanged(value);
            } else {
                this.mvc.view.$('div').css('display', Appearence.getDisplay(value));
            }
            parent = this.mvc.parent();

            if (value && parent) {
                //set false in other radiobuttons within current parent

                role = this.mvc.model.getRole();
                id = this.mvc.model.getId();

                for (i in parent._container.children) {
                    if (parent._container.children.hasOwnProperty(i)) {
                        child = parent._container.children[i];

                        if (child.model.getRole() === role
                            && child.model.getId() !== id) {
                            child.model.setIsChecked(false);
                        }
                    }
                }
            }
        },

        allowAct: function() {
        	this.mvc.model.setIsChecked(true);
        },

        onTextColorChanged: function (value) {

            this.mvc.view.$('div').css('background-color', value);
        },

        onClick: function (event) {
            this._super(event);
            if (event.handled) {
                return;
            }
            event.handled = true;
            if (!this.mvc.model.getIsEnabled()) {
                return;
            }

            var checked = this.mvc.model.getIsChecked();
            if (!checked) {
                this.askConfirmation();
            }
        }
    });

    return RadioButtonController;
});
