// <copyright file="Graph.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>


define(['base/ObservableObject', 'common/Enums', 'common/Appearence',
    'controls/Trend/modules/TrendlineBase', 'controls/Trend/modules/Alghoritms',
'controls/Trend/modules/models/BorderlineModel'],

    function (ObservableObject, Enums, Appearence, TrendlineBase, Alghoritms, BorderlineModel) {

        var Borderline = TrendlineBase.extend({
            init: function (idx, parent, model) {
                this.model = new BorderlineModel(idx, model);
                this._super(idx, parent, model);
                this.dataStorage.add(this.model.get(Enums.ParameterRoles.DATA_SOURCE),
                     this._generateTimePoint(), 0);
            },

            onDataSourceChanged: function (event) {
                if (event.newValue && event.newValue.value != undefined) {
                    var sourceTime = event.newValue.sourceTime != undefined ?
                        event.newValue.sourceTime : this._generateTimePoint();
                    this.dataStorage.add(event.newValue.value, +sourceTime, 0);
                }
            },

            update: function (canvas, canvasWidth, range, interval, mark, currTimestamp) {
                this.updateLine(canvas, canvasWidth, range, interval, mark, currTimestamp);
            },

            setCanvas: function (canvas) {
            },

            getFillDirection: function () {
                return this.model.get(Enums.ParameterRoles.FILL_DIRECTION);
            },

            select: function () {
            },

            _processLineClick: function (coord) {
            },

            reset: function () {
                var data = this.dataStorage.getAll();
                //сохраняем хотя бы один элемент, т.к
                //у границы он может задаваться только как константа
                var saved = data[data.length - 1];
                this._super();
                this.dataStorage.add(saved.value, this._generateTimePoint(), 0);
                saved = null;
                data = null;
            }
        });


        return Borderline;
    });