﻿define(['common/Enums', 'base/ObservableObject', 'common/Utilites'],
    function (Enums, ObservableObject, Utilites) {
        var timepointField = 'timepoint';
      var DisplaceQueue = ObservableObject.extend({    
        init: function (interval) {
            this._super();
            this.storage = []; //{ timepoint,value }
            this.interval = interval;          
            //for autoscale
            this.min = { value: +Infinity, timepoint: null};
            this.max = { value: -Infinity, timepoint: null };
            this.lastTimePoint = null;
        },

        add: function (value, timepoint, quality) {
            value = Number(value); //в редакторе DataSource - STRING         
            this.storage.push({ timepoint: +timepoint, value: value, quality: quality });
            if ((this.storage.length > 1) && this.storage[this.storage.length-1][timepointField] < this.storage[this.storage.length-2][timepointField])
                this.storage.sort(function (a, b) {
                    return a[timepointField] < b[timepointField] ?
                       -1 : a[timepointField] > b[timepointField] ? 1 : 0;
                });
            this._updateMinMax(value, timepoint);
        },

        addPacket: function (values) {
            for (j = 0; j < values.length ; j++) {
                this.storage.push({ timepoint: +values[j][0], value: values[j][1], quality: values[j][2] });
                this._updateMinMax(values[j][1], +values[j][0]);
            }
            this.storage.sort(function (a, b) {
                return a[timepointField] < b[timepointField] ?
                    -1 : a[timepointField] > b[timepointField] ? 1 : 0;
            });
        },

        cleanOldData: function (mark) {
            this.lastTimePoint = mark;
            var pointIndexesToRemove = this._getRemovingStorageIndexes(mark);
            //для корректного отображения, сохраняем одну точку за пределами интервала
            if (pointIndexesToRemove.length > 1) {
                pointIndexesToRemove.splice(pointIndexesToRemove.length - 1, 1);
                var needResetMinMax = this._chechIsNeedResetMinMax(pointIndexesToRemove);
                if (pointIndexesToRemove.length >= 1) {
                    var lastRemoveIndex = pointIndexesToRemove[pointIndexesToRemove.length - 1];
                    this.storage.splice(0, lastRemoveIndex + 1);
                }

                if (needResetMinMax) {
                    this._resetMinMax();
                }
            }       
        },

        _getRemovingStorageIndexes: function (timepoint) {
            var pointIndexesToRemove = [];
            var minTimePoint = timepoint - this.interval;           
            var i;
            for (i = 0; i < this.storage.length; i++) {
                if (this.storage[i].timepoint >= minTimePoint) {                    
                    break;
                }

                pointIndexesToRemove.push(i);
            }

            return pointIndexesToRemove;
        },

        _updateMinMax: function (value, timepoint) {            
            if(value >= this.max.value){
                this.max.value = value;
                this.max.timepoint = timepoint;
            }           

            if(value <= this.min.value){
                this.min.value = value;
                this.min.timepoint = timepoint;
            }
        },

        _chechIsNeedResetMinMax: function (removingTimePointsIndexes) {
            var i;
            for (i = 0; i < removingTimePointsIndexes.length; i++) {
                var removingElement = removingTimePointsIndexes[i];
                if (this.storage[removingElement].timepoint == this.min.timepoint ||
                    this.storage[removingElement].timepoint == this.max.timepoint) {                   
                    return true;
                }
            }

            return false;
        },

        _resetMinMax: function () {
            this.min = { value: +Infinity, timepoint: null, quality: Enums.DataQuality.good };
            this.max = { value: -Infinity, timepoint: null, quality: Enums.DataQuality.good };

            for(var i = 0, l = this.storage.length; i < l; ++i) {
                this._updateMinMax(this.storage[i].value, this.storage[i].timepoint);
            }       
        },

        clear: function () {
            this.storage = [];
            this.min = { value: +Infinity, timepoint: null, quality: Enums.DataQuality.good };
            this.max = { value: -Infinity, timepoint: null, quality: Enums.DataQuality.good };
        },

        getAll: function () {
            return this.storage;
        },

        getMin: function () {
            return this.min;
        },

        getMax: function () {
            return this.max;
        },

        setInterval: function (interval) {
            this.interval = interval;
        }
    });

        return DisplaceQueue;
});