﻿// <copyright file="HideMiniLegendCircle.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// <author>Bogdan Nosachenko b.nosachenko@infostroy-software.com</author>

/*
* @class HideMiniLegendCircle class for hide or open MiniLegend
*/
define(['common/Enums', ],
    function (Enums) {

        var HideMiniLegendCircle = Class.extend({

            options: {
                circulRadius: 12,
                lineWidth: 2,
                strokeStyle: '#8B0000'
            },

            init: function (canvas, model) {
                this.canvas = canvas;
                this.canvas.addHitRegion(Enums.EventType.click, this._onCircleClick.bind(this));
                this.model = model;
                this.xCenter = 0
                this.yCenter = this.options.circulRadius;
                this.isLegend = this.model.get(Enums.ParameterRoles.SHOW_LEGEND);
                this.isInSircle = false;
            },

            draw: function () {
                var circle = {};
                circle.radius = this.options.circulRadius;
                circle.xCenter = this.xCenter;
                circle.yCenter = this.yCenter;
                circle.strokeStyle = this.options.strokeStyle;
                this._drawLine();
                this._drawAxis();
                this.canvas.drawCircle(circle);
            },

            _drawLine: function () {

                this.canvas.drawLine({
                    x1: this.xCenter,
                    y1: this.yCenter - this.options.circulRadius / 2,
                    x2: this.xCenter,
                    y2: this.yCenter + this.options.circulRadius * 0.5,
                    strokeStyle: this.options.strokeStyle,
                    lineWidth: this.options.lineWidth
                })
            },

            _drawAxis: function () {
                var y = this.isLegend ? (this.yCenter - this.options.circulRadius / 2) :
                        this.yCenter + this.options.circulRadius * 0.5;

                this.canvas.drawLine({
                    x1: this.xCenter - this.options.circulRadius * 0.4,
                    y1: this.yCenter,
                    x2: this.xCenter,
                    y2: y,
                    strokeStyle: this.options.strokeStyle,
                    lineWidth: this.options.lineWidth
                }).drawLine({
                    x1: this.xCenter + this.options.circulRadius * 0.4,
                    y1: this.yCenter,
                    x2: this.xCenter,
                    y2: y,
                    strokeStyle: this.options.strokeStyle,
                    lineWidth: this.options.lineWidth
                })
            },

            _onCircleClick: function (coords, eventType, event) {
                // equation of a circle
                var distance = Math.pow((coords.x - this.xCenter), 2) +
                    Math.pow((coords.y - this.yCenter), 2) - Math.pow(this.options.circulRadius, 2);

                if (distance <= 0) {
                    if (this.model.get(Enums.ParameterRoles.SHOW_LEGEND)) {
                        this.model.set(Enums.ParameterRoles.SHOW_LEGEND, false);
                        this.isLegend = false;
                    } else {
                        this.model.set(Enums.ParameterRoles.SHOW_LEGEND, true);
                        this.isLegend = true;
                    }

                    this.isInCircle = true;
                    return true;
                }

            }

        })
        return HideMiniLegendCircle
    })