﻿// <copyright file="Graph.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>


define(['controls/Trend/modules/models/TrendlineModel', 'common/Enums'], function (TrendlineModel, Enums) {

    var BorderlineModel = TrendlineModel.extend({

        getSelectionColor: function () {
            //граница не содержит логики выделения
            return undefined;
        },

        drawIfNoData: function () {
            //граница может быть константной, поэтому
            //её всегда нужно дорисовавать
            return true;
        },
        getLineJoin: function () {
            return Enums.LineJoin.Line;
        },
        getLineColor: function () {
            return this.get(Enums.ParameterRoles.COLOR);
        },
        getThickness: function () {
            return this.get(Enums.ParameterRoles.LINE_WIDTH);
        },
        getFalseyValuesLinestyle: function () {
            //границы не имеют statusCode
            return Enums.BorderStyleType.None;
        },
    });

    return BorderlineModel;
});