﻿// <copyright file="WindowWrapperControl.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// 

define([{{ controlType }}, 'controls/WindowWrapper/WindowWrapperModel', 'controls/WindowWrapper/WindowWrapperController',
'core/Statistic', 'common/Enums'],
    function (controlType, WindowWrapperModel, WindowWrapperController,  Statistic, Enums) {        

        return function (parentResourceManager, typeExtender) {
            var statisticId = Statistic.startMeasurement(Enums.statisticType.window);

            var type = typeExtender!==undefined ?  $.extend(true, {}, controlType, typeExtender) : controlType;
            var win =  $$({
                model: new WindowWrapperModel(type, parentResourceManager),
                view: { format: '<div></div>' },
                controller: new WindowWrapperController(statisticId)
            });

            return win;
        };
    });