﻿// <copyright file="OpenWindowAction.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// 


define(['core/actions/OpenWindowActionBase', 'core/WindowsManager', 'common/Appearence',
    'common/Enums', 'server/sources/SchemeVariablesSource', 'core/L10n',
    'core/global/GlobalSettings', 'common/Utilites', 'helpers/contextResolver'
], function (OpenWindowActionBase, WindowsManager, Appearence,
    Enums, SchemeVariablesSource, L10n, GlobalSettings, Utilites, contextResolver) {

    var ControlFactory;
    var OpenDialogFrameControl;

    //broke cirle dependencies
    curl(['controls/ControlFactory'], function (cf) {
        ControlFactory = cf;
    });

    curl(['core/actions/OpenDialog/OpenDialogFrameControl'], function (cf) {
        OpenDialogFrameControl = cf;
    });

    var OpenDialogAction = OpenWindowActionBase.extend({
        openedWindowsIdCounter: 0,
        init: function (options) {
            this._super(options);

            this._onResizeBind = this._onResize.bind(this);
        },

        executeInternal: function (context, resolve, reject, notify) {

            if (this.dialogContainer) {
                return;
            }

            var dialogContainer = new OpenDialogFrameControl(context.mvc.model.resourceManager);
            this.dialogContainer = dialogContainer;
            dialogContainer.model.initModel(this._getFrameModel());
            dialogContainer._parent = contextResolver.getRootWindow(context);
            var windowModeloriginal = WindowsManager.getWindowModelById(this.constants.WindowId);
            var windowModel = {};
            this._addInputParams();

            //не портим оригинальную модель
            $.extend(true, windowModel, windowModeloriginal, {
                parameters: this.replacedModelParameters
            });

            dialogContainer.controller.setWindow(windowModel, true);

            this._bindProperties();

            //т.к в диалоге, то не должны быть absolute
            //dialogContainer.view.$().css('position', 'static');
            //agility контейней обеспечет правильную отработку логики контрола окна
            //this.dialogContainer = this._createContainer();
            var options = this.getOptions(dialogContainer.view.$(), resolve);
            var dlg = dialogContainer.view.$().dialog(options);
            var collapse = this.getCollapseButton();
            if (this.get(Enums.ParameterRoles.CAN_MINIMIZE)) {
                collapse.style.display = 'block';
            }
            else {
                collapse.style.display = 'none';
            }

            if (this.get(Enums.ParameterRoles.CAN_CLOSE) === false) {
                this.getCloseButton().style.display = 'none';
            }

            //#10818
            if(Utilites.isWebkit()){
                var handles = dlg.parent().children('.ui-resizable-handle');
                handles.hide().width();
                handles.show();
                handles = null;
                dlg = null;
            }

            //у frame нет parent, поэтому для него он не имеет смысла
            dialogContainer.controller.getNestedWindow().controller.onAddedToParent();
            dialogContainer.controller.updateChildWindowSize();

            dialogContainer.controller.applyWidth(true);
            dialogContainer.controller.applyHeight(true);

            this._onPositionChanged();
        },

        getCollapseButton: function () {
            return this.dialogContainer.view.$().offsetParent()[0].getElementsByClassName("ui-dialog-titlebar-collapse")[0];
        },

        getCloseButton: function () {
            return this.dialogContainer.view.$().offsetParent()[0].getElementsByClassName("ui-dialog-titlebar-close")[0];
        },

        getCollapseRestoreButton: function () {
            return this.dialogContainer.view.$().offsetParent()[0].getElementsByClassName("ui-dialog-titlebar-collapse-restore")[0];
        },

        getWindow: function () {
            return this.dialogContainer.controller.getNestedWindow();
        },

        _onModelPropertyChanged: function (event) {
            this._super(event);

            switch (event.property) {
                case Enums.ParameterRoles.TEXT:
                    if (this.getWindow() !== null && this.dialogContainer !== null) {
                        this.dialogContainer.view.$().dialog('option', 'title', event.newValue.value);
                    }
                    break;
                case Enums.ParameterRoles.WIDTH:
                    if (this.getWindow()) {
                        var ew = this._createActualWidthChangedEvent(this.get(Enums.ParameterRoles.WIDTH), this);
                        this.dialogContainer.view.$().dialog({
                            minWidth: this.get(Enums.ParameterRoles.WIDTH),
                            width: this.get(Enums.ParameterRoles.WIDTH),
                            height: this.get(Enums.ParameterRoles.HEIGHT)
                        });
                        this.getWindow().controller.onParentActualWidthChanged(ew);
                    }
                    break;
                case Enums.ParameterRoles.HEIGHT:
                    if (this.getWindow()) {
                        var eh = this._createActualHeightChangedEvent(this.get(Enums.ParameterRoles.HEIGHT), this);
                        this.dialogContainer.view.$().dialog({
                            minWidth: this.get(Enums.ParameterRoles.WIDTH),
                            height: this.get(Enums.ParameterRoles.HEIGHT),
                            width: this.get(Enums.ParameterRoles.WIDTH)
                        });
                        this.getWindow().controller.onParentActualHeightChanged(eh);
                    }
                case Enums.ParameterRoles.X:
                case Enums.ParameterRoles.Y:
                    if (this.getWindow()) {
                        this._onPositionChanged();
                    }
                    break;
                case Enums.ParameterRoles.DIALOG_HEADER_TEXT_COLOR:
                    if (this.getWindow() !== null && this.dialogContainer !== null) {
                        this.dialogContainer.view.$().dialog('option', 'titleTextColor', event.newValue.value);
                    }
                    break;
                case Enums.ParameterRoles.HEADER_BACKGROUND_COLOR:
                    if (this.getWindow() !== null && this.dialogContainer !== null) {
                        this.dialogContainer.view.$().dialog('option', 'backgroundColor',
                            Appearence.color.toCssColor(event.newValue.value));
                    }
                    break;
                case Enums.ParameterRoles.SIZE_TO_CONTENT:
                    this.dialogContainer.view.$().trigger('resize');
                    break;
                case Enums.ParameterRoles.CAN_MINIMIZE:
                    var collapse = this.getCollapseButton();
                    var collapse_restore = this.getCollapseRestoreButton();
                    if (event.newValue.value) {
                        if (this.isCollapsed()) {      //если окно скрыто
                            collapse_restore.style.display = 'block';//то восстанавливать нужно рестор
                        }
                        else {
                            collapse.style.display = 'block';
                        }
                    } else {
                        collapse_restore.style.display = 'none';
                        collapse.style.display = 'none';
                    }
                    break;
                case Enums.ParameterRoles.CAN_RESIZE:
                    this.dialogContainer.view.$().dialog('option', 'resizable', event.newValue.value);
                    break;
            }
        },

        isCollapsed: function() {
            return this.dialogContainer.view.$().css('height') == '0px';
        },

        _onPositionChanged: function () {
            if (this.isPropertyExists(Enums.ParameterRoles.X)) {
                var x = this.get(Enums.ParameterRoles.X);
                this.dialogContainer.view.$().dialog("widget").css({
                    left: x
                });
            }
            if (this.isPropertyExists(Enums.ParameterRoles.Y)) {
                var y = this.get(Enums.ParameterRoles.Y);
                this.dialogContainer.view.$().dialog("widget").css({
                    top: y
                });
            }
        },

        _onResize: function (width, height) {
            if (this.get(Enums.ParameterRoles.SIZE_TO_CONTENT) === Enums.SizeToContentType.SetSize) {
                this.dialogContainer.controller.setControlHeight(height);
                this.dialogContainer.controller.setControlWidth(width);
            }

            //ресайзим содержимое окон
            var ew = this._createActualWidthChangedEvent(width, this);
            var eh = this._createActualHeightChangedEvent(height, this);


            this.dialogContainer.controller.getNestedWindow().controller.onParentActualWidthChanged(ew);
            this.dialogContainer.controller.getNestedWindow().controller.onParentActualHeightChanged(eh);
        },

        getOptions: function (dialogContainer, resolve) {
            var backgroundColor = Appearence.color.toCssColor(this.get(Enums.ParameterRoles.HEADER_BACKGROUND_COLOR));
            var that = this;
            var options = {
                resizable: this.get(Enums.ParameterRoles.CAN_RESIZE),
                collapseEnabled: true,
                title: this.get(Enums.ParameterRoles.TEXT),
                backgroundColor: backgroundColor,
                titleTextColor: this.get(Enums.ParameterRoles.DIALOG_HEADER_TEXT_COLOR),
                headerHeight: GlobalSettings.get(Enums.ParameterRoles.DIALOG_HEADER_HEIGHT),
                headerFontSize: GlobalSettings.get(Enums.ParameterRoles.DIALOG_HEADER_FONT_SIZE),
                headerFontName: GlobalSettings.get(Enums.ParameterRoles.DIALOG_HEADER_FONT_NAME),
                width: 'auto',
                height: 'auto',
                containment: 'parent',
                closeText: L10n.get('messages.dialogClose'),
                collapseText: L10n.get('messages.dialogCollapse'),
                restoreText: L10n.get('messages.dialogRestore'),
                close: function (event, ui) {
                    that._retrieveOutputPrams();
                    that.unsubscribePropertyChanged(that._onModelPropertyChanged);
                    that.getWindow().model.unsubscribePropertyChanged(that._onWindowPropertyChanged);
                    that.dialogContainer.controller.removeChildControl(that.dialogContainer.controller.frameWindow);
                    that.dialogContainer.destroy();
                    that.dialogContainer = null;
                    $(this).remove();
                    resolve();
                },

                resize: function (event, ui) {
                    that._onResizeBind(event.target.offsetWidth, event.target.offsetHeight);
                }
            };

            return options;
        },

        _createActualWidthChangedEvent: function (value, context) {
            return {
                sReFired: true,
                target: context,
                type: "actual width changed",
                value: value
            };
        },

        _createActualHeightChangedEvent: function (value, context) {
            return {
                sReFired: true,
                target: context,
                type: "actual height changed",
                value: value
            };
        },

        _getFrameModel: function () {
            return {
                "typeName": "",
                "parameters": {
                    "Height": {
                        "typeName": "LREAL",
                        "typeHash": 1,
                        "value": this.get(Enums.ParameterRoles.HEIGHT)
                    },
                    "Width": {
                        "typeName": "LREAL",
                        "typeHash": 1,
                        "value": this.get(Enums.ParameterRoles.WIDTH)
                    },
                    "SizeToContent": {
                        "typeName": "HMI.SizeToContentType",
                        "typeHash": 0,
                        "value": this.get(Enums.ParameterRoles.SIZE_TO_CONTENT)
                    }
                },
                "connections": [],
                "events": [],
                "triggers": [],
                "actions": [],
                "serverVariables": {
                    "getValues": [],
                    "setValues": []
                },
                "childModels": [],
                "serviceParameters": null
            };
        },

        destroy: function () {
            if (this.dialogContainer) {
                this.dialogContainer.controller.removeChildControl(this.dialogContainer.controller.frameWindow);
                this.dialogContainer.view.$().dialog('destroy').remove();
            }
        }

    });


    return OpenDialogAction;
});
