﻿// <copyright file="TriggerHandler.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// 


define(['common/Enums', 'core/trigger/Trigger'], function (Enums, Trigger) {
    function TriggerHandler(actionsStorage) {
        this.actionsStorage = actionsStorage; //Actions objects
        this.triggers = [];
        this.triggersDictionary = {};
        this.triggersActionsDicrionary = {}; //actionId : triggerId
        this.propertyActionDictionary = {};//actionId : [fullPropPath] //куда акшен может писать
        this.state = { currentActionId: null };
        this.locksDictionary = {}; //fullPropPath : {[actionId]}
    };

    TriggerHandler.prototype.add = function (triggers, context) {       
        var i = 0;
        for (i; i < triggers.length; i++) {
            if (this.triggersDictionary[triggers[i].id] === undefined) {
                var trigger = new Trigger(triggers[i], this.actionsStorage, context);
                this.triggers.push(trigger);
                this.triggersDictionary[triggers[i].id] = trigger;
                trigger.subscribeTriggerUndo(function (locksDictionary, propertyActionDictionary, actionsStorage, state) {
                    return function (event) {                        
                        var i;
                        //удаляемся, для каждого акшена триггера проходим по локам
                        for (i = 0; i < event.target.actions.length; i++) {
                            var actionId = event.target.actions[i].id;
                            var fullPropPaths = propertyActionDictionary[actionId]; //куда акшен пишет
                            var j;
                            for (j = 0; j < fullPropPaths.length; j++) {
                                var fullPath = fullPropPaths[j];
                                //если есть блок на свойство, 
                                if (locksDictionary[fullPath]) {
                                    //и этот акшен тоже блочил
                                    var position = locksDictionary[fullPath].indexOf(actionId);                                      

                                    if (position == -1) { //не блочил
                                        continue;                                       
                                    }
                                    //если есть кто-то на позицию выше нас (0-й дефолтный сеттер, 1-й и т.д уже акшены)                                    
                                    if ((locksDictionary[fullPath].length  - 1) > position) {
                                        //тихо удаляемся
                                        locksDictionary[fullPath].splice(position, 1);
                                        continue;    
                                    }

                                    locksDictionary[fullPath].splice(position, 1);
                                    //если после нашего удаления остался только 1 элемент - это сеттер дефолтного значения
                                    if (locksDictionary[fullPath].length == 1) {
                                        var setter = locksDictionary[fullPath][0];
                                        locksDictionary[fullPath] = undefined; //указываем, что свойство свободно
                                        state.currentActionId = -1;
                                        setter(); //теперь восстанавливаем значение                                                                          
                                        state.currentActionId = null;
                                    } else { //иначе  - акшен другого триггера
                                        //вызываем его, что б он просетил свое значение   
                                        //он точно актуален, находится в нужном месте, иначе б удалился
                                        var targetActionId = this.triggersActionsDicrionary[locksDictionary[fullPath][locksDictionary[fullPath].length - 1]];
                                        actionsStorage[targetActionId].execute();
                                    }                             
                                }
                            }
                        }                 
                    }
                }(this.locksDictionary, this.propertyActionDictionary, this.actionsStorage, this.state));

                this.resolveTriggerActions(trigger, triggers[i]);
            }
        }
    }

    TriggerHandler.prototype.resolveTriggerActions = function (trigger, triggerOptions) {
        var i;
        for (i = 0; i < triggerOptions.actions.length; i++) {
            var action = this.actionsStorage[triggerOptions.actions[i]];
            this.triggersActionsDicrionary[action.id] = trigger.id;
            action.subscribeBeforeExecuteAction(function (triggersActionsDicrionary, state) {
                return function (event) {
                    if (triggersActionsDicrionary[event.actionId]) {
                        state.currentActionId = event.actionId;
                    }
                }
            }(this.triggersActionsDicrionary, this.state));

            action.subscribeAfterExecuteAction(function (state) {
                return function (event) {
                        state.currentActionId = null;   //можно без проверки - подписаны только на триггерские                 
                }
            }(this.state));

            trigger.actions.push(action);
        }
    }

    TriggerHandler.prototype.init = function (ctx) {        
        var i, j;
        this.context = ctx;
        for (i = 0; i < this.triggers.length; i++) {
            var trigger = this.triggers[i];
            for (j = 0; j < trigger.actions.length; j++) {
                var action = trigger.actions[j];
                this.propertyActionDictionary[action.id] = [];
                _.forOwn(ctx.mvc.model.getType()._connectionsHandler.connections, function (connections, fullPath) {
                    if (fullPath.indexOf(action.id) != -1) {
                        this.propertyActionDictionary[action.id].push(fullPath);
                        for (var k = 0; k < connections.length; k++) {
                            connections[k].target.getDataSource(ctx.mvc).subscribePropertyChanging(function (state, fullPath, actionId, locksDictionary, propertyPath) {
                                return function (changingEvent) {
                                    if (changingEvent.property !== propertyPath) {
                                        //т.к мы подписаны на изменения любого свойства модели,
                                        //у которой хотя бы в одно её свойство пишет триггер,
                                        //то нужно проверять, идет ли сейчас запись в свойство,
                                        //в которое пишет триггер
                                        return;
                                    }
                                    //fullPath - путь Target SetParameterValueAction
                                    //если сейчас активен акшен - то это он и пишет - джаваскрипт однопоточный, так что даже свойсво проверять не надо
                                    if (state.currentActionId === -1) { //если восстанавливаем значение
                                        return;
                                    }
                                                                        
                                    if (state.currentActionId !== null && state.currentActionId == actionId) { 
                                        //перемещаемся на вершину локов :
                                        if (locksDictionary[fullPath]) //если такое свойство уже есть
                                        {
                                            var position = _.findIndex(locksDictionary[fullPath], function(lock) {
                                                return lock == actionId
                                            });

                                            if (position != -1) { //и наша блокировка тоже уже есть - то удаляем ее
                                                locksDictionary[fullPath].splice(position, 1);
                                            }
                                            
                                        }
                                        //если первые, кто блокируем
                                        if (locksDictionary[fullPath] === undefined) {
                                            locksDictionary[fullPath] = [];
                                            //запоминаем стартовое значение
                                            locksDictionary[fullPath].push(
                                               (function (target, property, value) {
                                                    return function () {
                                                        target.set(property, value);
                                                    }
                                               })(changingEvent.target, changingEvent.property, changingEvent.oldProperty != undefined ? changingEvent.oldProperty.value : undefined)
                                                );
                                        }
                                      
                                        locksDictionary[fullPath].push(actionId);

                                        return; //разрешаем запись                                                                             
                                    } else if (state.currentActionId === null && locksDictionary[fullPath] !== undefined) {
                                        //свойство держит триггер
                                        changingEvent.cancel = true;
                                    }
                                }
                            }(this.state, fullPath, action.id, this.locksDictionary, connections[k].target.propertyPath));
                        }
                    }
                }, this);
            }
        }
    }

    TriggerHandler.prototype.applyAll = function () {
        var i;
        for (i = 0 ; i < this.triggers.length; i++) {
            this.triggers[i].onConditionStateChanged(this.context);
        }
    }

    return TriggerHandler;
})