﻿// <copyright file="ControlModel.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// 

/*
* @class ControlModel
* Base class for models of controls
*/
define(['common/Enums', 'base/Model', 'core/connection/ConnectionHandler', 'core/trigger/TriggerHandler',
    'core/ResourceManager'],
    function (Enums, Model, ConnectionHandler, TriggerHandler, ResourceManager) {

        var MODEL_INIT_EVENT = 'init';
        var MODEL_AFTER_INIT_EVENT = 'after init';

        var ControlModel = Model.extend({

            init: function (type, parentResourceManager) {
                //contains reference to resources dictionary
                //or reference to own dictionary (resources of type + resource of dictionary)
                this.resources = null;
                this._data = null;
                this.events = null; //event[role] = [actionId,....]
                this.actions = []; // { id: {, type: "", constants:{}, parameters: { param: {value: ""}}}}
                this.triggers = [];
                this.permissions = {};
                this._super();

                this.type = type;

                this.serverVariables = {
                    getValues: [],
                    setValues: []
                };

                this._mergeServerVariables(this.serverVariables.getValues, this.type.serverVariables.getValues);
                this._mergeServerVariables(this.serverVariables.setValues, this.type.serverVariables.setValues);

                if (!this.type._connectionsHandler) {
                    this.type._connectionsHandler = new ConnectionHandler();
                }

                mergeEvents.call(this, this.type.events);
                $.extend(true, this.permissions, this.type.permissions);
                //this.permissions = this.permissions.concat(this.type.permissions);
                this.actions = this.actions.concat(this.type.actions);
                this.triggers = this.triggers.concat(this.type.triggers);

                // собственные ресурсы живут в типе, поэтому, сорри, только раз
                if (!this.getType().resourcesProcessed) {
                    this.getType().resourceManager = new ResourceManager();
                    processResources.call(this, this.getType().resources || []);
                    this.getType().resourcesProcessed = true;
                }
                //а вот экзмепляр должен содержать ресурсы типа, и ссылку на родителя
                this.resourceManager = new ResourceManager(parentResourceManager);
                this.resourceManager.setAll(this.getType().resourceManager.getAll());


                processNewParameters.call(this);
            },

            resolveResource: function (resourceName) {

            },

            getType: function () {
                return this.type;
            },

            getConnectionHandler: function () {
                return this.type._connectionsHandler;
            },

            updateTypeConnections: function (ctx) {
                this.getType()._connectionsHandler.updateAll(ctx);
            },

            overrideConnectionsOperation: function (property, operation) {
                this.getType()._connectionsHandler.overrideOperation(property, operation);
            },

            restoreConnectionsOperation: function (property) {
                this.getType()._connectionsHandler.restoreOperation(property);
            },

            updateTypeConnection: function (prop, ctx, sourceOldValue) {
                this.getType()._connectionsHandler.onchange(prop, ctx, sourceOldValue);
            },

            initModel: function (model) {
                this.applyModel(model);
                this.fireOnInit();
                this.fireAllPropertiesChanged();
                this.fireOnAfterInit();
            },
            fireAllPropertiesChanged: function(){
                //TODO: тогда уберем для атачед пропертиес в контейнере
                if (this._data["optimization"]) {
                    this.firePropertyChanged(Enums.ParameterRoles.X);
                    this.firePropertyChanged(Enums.ParameterRoles.Y);
                    this.firePropertyChanged(Enums.ParameterRoles.WIDTH);
                    this.firePropertyChanged(Enums.ParameterRoles.HEIGHT);
                    this.firePropertyChanged(Enums.ParameterRoles.FONT_SIZE);
                    this.firePropertyChanged(Enums.ParameterRoles.RESOURCE);
                    this.firePropertyChanged(Enums.ParameterRoles.ID);
                } else {
                    for (var property in this._data) {
                        if (property.indexOf("svg") == -1)
                            this.firePropertyChanged(property);
                    }
                }
            },
            applyModel: function (model) {
                //apply model

                if (model && model.parameters) {
                    this._mergeModelParameters(model.parameters);
                }

                if (model && model.events) {
                    mergeEvents.call(this, model.events);
                }

                if (model && model.actions) {
                    this.actions = this.actions.concat(model.actions);
                }

                if (model && model.triggers) {
                    this.triggers = this.triggers.concat(model.triggers);
                }

                if (model && model.permissions) {
                    this.permissions = $.extend(true, this.permissions, model.permissions);
                }
                if (model && model.shortName !== undefined) {
                    this.shortName = model.shortName;
                }
                this.hasConnections = model.hasConnections;

                if (model.serverVariables) {
                    this._mergeServerVariables(this.serverVariables.getValues, model.serverVariables.getValues);
                    this._mergeServerVariables(this.serverVariables.setValues, model.serverVariables.setValues);
                }

                if (model.objectId !== 0 && model.serverTaskId >= 0) {
                    this.objectId = model.objectId;
                    this.serverTaskId = model.serverTaskId;
                    this._setServerVariablesObjectId(this.serverVariables.getValues);
                    this._setServerVariablesObjectId(this.serverVariables.setValues);
                }
            },
            _mergeModelParameters: function (modelParams) {
                var i,
                    propKeys = Object.keys(modelParams);

                for (i = 0; i < propKeys.length; i++) {
                    this._data[propKeys[i]] = {};
                    $.extend(true, this._data[propKeys[i]], modelParams[propKeys[i]]);
                }
            },

            destroy: function () {
                this.actions = null;
                this.triggers = null;
                this.getType()._connectionsHandler.resetLastValues();
            },

            getId: function () {
                return this.get(Enums.ParameterRoles.ID);
            },

            getRole: function () {
                return this.get(Enums.ParameterRoles.ROLE);
            },

            getParameters: function () {
                return this.getType().parameters;
            },

            getTriggers: function () {
                return this.type.triggers;
            },

            getEvents: function () {
                return this.type.events;
            },

            getResourceById: function (id) {
                return this.resources[id];
            },

            getIsVisible: function () {
                return this.get(Enums.ParameterRoles.IS_VISIBLE);
            },

            setIsVisible: function (value) {
                return this.set(Enums.ParameterRoles.IS_VISIBLE, value);
            },

            getOpacity: function () {
                return this.get(Enums.ParameterRoles.OPACITY);
            },

            setOpacity: function (value) {
                return this.set(Enums.ParameterRoles.OPACITY, value);
            },

            getX: function () {
                return this.get(Enums.ParameterRoles.X);
            },

            setX: function (value) {
                return this.set(Enums.ParameterRoles.X, value);
            },

            getXUnits: function () {
                return this.get(Enums.ParameterRoles.X_UNITS);
            },

            getY: function () {
                return this.get(Enums.ParameterRoles.Y);
            },

            setY: function (value) {
                return this.set(Enums.ParameterRoles.Y, value);
            },

            getYUnits: function () {
                return this.get(Enums.ParameterRoles.Y_UNITS);
            },

            getWidthUnits: function () {
                return this.get(Enums.ParameterRoles.WIDTH_UNITS);
            },

            getWidth: function () {
                return this.get(Enums.ParameterRoles.WIDTH);
            },

            setWidth: function (value) {
                return this.set(Enums.ParameterRoles.WIDTH, value);
            },

            getHeightUnits: function () {
                return this.get(Enums.ParameterRoles.HEIGHT_UNITS);
            },

            getHeight: function () {
                return this.get(Enums.ParameterRoles.HEIGHT);
            },

            setHeight: function (value) {
                return this.set(Enums.ParameterRoles.HEIGHT, value);
            },

            getAnchor: function () {
                return this.get(Enums.ParameterRoles.ANCHOR);
            },

            getAngle: function () {
                return this.get(Enums.ParameterRoles.ANGLE);
            },

            setAngle: function (value) {
                return this.set(Enums.ParameterRoles.ANGLE, value);
            },

            setScaleX: function (value) {
                return this.set(Enums.ParameterRoles.SCALE_X, value);
            },

            getIsEnabled: function () {
                return this.get(Enums.ParameterRoles.IS_ENABLED);
            },

            setIsEnabled: function (value) {
                return this.set(Enums.ParameterRoles.IS_ENABLED, value);
            },

            getBackgroundColor: function () {
                return this.get(Enums.ParameterRoles.BACKGROUND_COLOR);
            },

            getBackgroundTile: function () {
                return this.get(Enums.ParameterRoles.BACKGROUND_TILE);
            },

            getShadowColor: function () {
                return this.get(Enums.ParameterRoles.SHADOW_COLOR);
            },

            setShadowColor: function (value) {
                return this.set(Enums.ParameterRoles.SHADOW_COLOR, value);
            },

            getShadowSize: function () {
                return this.get(Enums.ParameterRoles.SHADOW_SIZE);
            },

            getBorderColor: function () {
                return this.get(Enums.ParameterRoles.BORDER_COLOR);
            },

            getBorderStyle: function () {
                return this.get(Enums.ParameterRoles.BORDER_STYLE);
            },

            getBorderThickness: function () {
                return this.get(Enums.ParameterRoles.BORDER_THIKNESS);
            },

            setBorderThickness: function (value) {
                return this.set(Enums.ParameterRoles.BORDER_THIKNESS, value);
            },
            getResource: function () {
                return this.get(Enums.ParameterRoles.RESOURCE);
            },

            setResource: function (value) {
                return this.set(Enums.ParameterRoles.RESOURCE, value);
            },

            _mergeServerVariables: function (existSV, newSV) {
                newSV.forEach(function (sv) {
                    if (_.find(existSV, { 'itemId': sv['itemId'], 'path': sv['path'] }) === undefined) {
                        existSV.push($.extend(true, {}, sv));
                    }
                });
            },

            _setServerVariablesObjectId: function (svlist) {
                var that = this;
                svlist.forEach(function (sv) {
                    if (sv.itemId === 0 && sv.taskId < 0) {
                        sv.itemId = that.objectId;
                        sv.taskId = that.serverTaskId;
                    }
                });
            },

            subscribeOnInit: function (handler, context) {
                this.eventTarget.addListener(MODEL_INIT_EVENT, handler, context);
            },

            unsubscribeOnInit: function (handler) {
                this.eventTarget.removeListener(MODEL_INIT_EVENT, handler);
            },

            fireOnInit: function () {
                this.eventTarget.fire({ type: MODEL_INIT_EVENT, target: this });
            },

            subscribeOnAfterInit: function (handler, context) {
                this.eventTarget.addListener(MODEL_AFTER_INIT_EVENT, handler, context);
            },

            unsubscribeOnAfterInit: function (handler) {
                this.eventTarget.removeListener(MODEL_AFTER_INIT_EVENT, handler);
            },

            fireOnAfterInit: function () {
                this.eventTarget.fire({ type: MODEL_AFTER_INIT_EVENT, target: this });
            },

            //Alex: to let know agility to not make proxy for models
            _noProxy: function () { },
        });

        function processParameter(parameter) {

            if (this._data[parameter.role] === undefined) {
                this._data[parameter.role] = $.extend(true, {}, parameter.defaultValue);
            }
        }

        function processNewParameters() {

            var i,
                parameter,
                parameters = this.getParameters();

            for (i = parameters.length; i--;) {
                parameter = parameters[i];

                processParameter.call(this, parameter);
            }
        }

        function processResources(resources) {
            var shortname;
            for (var i = 0, l = resources.length; i < l; ++i) {
                this.getType().resourceManager.add(resources[i].id, resources[i].url);
                var types = { 'svg': 0, 'png': 1 };
                var pair = resources[i].id.split('.').splice(-2);
                if (pair[1])
                    shortname = pair[1].toLowerCase() in types ? pair.join('.') : pair[1];
                else
                    shortname = pair[0].toLowerCase() in types ? pair.join('.') : pair[0];
                if (shortname != resources[i].id) {
                    this.getType().resourceManager.add(shortname, resources[i].url);
                }
            }
        }

        function mergeEvents(events) {

            if (!events) {
                return;
            }

            this.events = this.events || {};

            var i;
            for (i = 0; i < events.length; i++) {
                var addingEvent = events[i];
                if (this.events[addingEvent.type]) {
                    this.events[addingEvent.type].actions = this.events[addingEvent.type].actions.concat(addingEvent.actions);
                    this.events[addingEvent.type].isTrigger = this.events[addingEvent.type].isTrigger || this.events[addingEvent.type].isTrigger;
                }
                else {
                    this.events[addingEvent.type] = $.extend(true, {}, addingEvent);
                }
            }
        }

        return ControlModel;
    });
