﻿// <copyright file="ObservableObject.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// 

/*
* @class ObservableObject
* This class is JS implementation of INotifyPropertyChanged interface
*/
define(['base/EventTarget'], function (EventTarget) {

    var PROPERTY_CHANGED = 'property changed',
        PROPERTY_CHANGING = 'property changing';

    var ObservableObject = Class.extend({

        eventTarget: null,

        init: function () {
            this.eventTarget = new EventTarget();
        },

        /*
        * @function
        * @name subscribePropertyChanging
        * @param handler {function} function (event{target, type, property}){}
        *   target - event initiator (sender)
        *   type - event type (always 'property changed')
        *   property - name of property
        * @param context {object} will be 'this' in handler
        */
        subscribePropertyChanging: function (handler, context) {

            this.eventTarget.addListener(PROPERTY_CHANGING, handler, context);

        },

        /*
        * @function
        * @name subscribePropertyChanging
        * @param handler {function} function (event{target, type, property}){}
        *   target - event initiator (sender)
        *   type - event type (always 'property changed')
        *   property - name of property
        * @param context {object} will be 'this' in handler
        */
        subscribePropertyChangingOnce: function (handler, context) {

            this.eventTarget.bindOnce(PROPERTY_CHANGING, handler, context);

        },

        /*
        * @function
        * @name unsubscribePropertyChanging
        * @param handler {function} function (event{target, type, property}){}        
        */
        unsubscribePropertyChanging: function (handler) {

            this.eventTarget.removeListener(PROPERTY_CHANGING, handler);

        },

        /*
        * @function 
        * @name subscribePropertyChanged
        * @param name {string} property name
        * @param oldValue - old value of property
        * @param newValue - newValue of property
        */
        firePropertyChanged: function (name, oldValue, newValue) {

            this.eventTarget.fire({
                type: PROPERTY_CHANGED,
                target: this,
                property: name,
                oldValue: oldValue,
                newValue: newValue
            });
        },

        /*
        * @function
        * @name subscribePropertyChanged
        * @param handler {function} function (event{target, type, property}){}
        *   target - event initiator (sender)
        *   type - event type (always 'property changed')
        *   property - name of property
        * @param context {object} will be 'this' in handler
        */
        subscribePropertyChanged: function (handler, context) {

            this.eventTarget.addListener(PROPERTY_CHANGED, handler, context);

        },

        /*
        * @function
        * @name subscribePropertyChanged
        * @param handler {function} function (event{target, type, property}){}
        *   target - event initiator (sender)
        *   type - event type (always 'property changed')
        *   property - name of property
        * @param context {object} will be 'this' in handler
        */
        subscribePropertyChangedOnce: function (handler, context) {

            this.eventTarget.bindOnce(PROPERTY_CHANGED, handler, context);

        },

        /*
        * @function
        * @name unsubscribePropertyChanged
        * @param handler {function} function (event{target, type, property}){}        
        */
        unsubscribePropertyChanged: function (handler) {

            this.eventTarget.removeListener(PROPERTY_CHANGED, handler);

        }       

    });

    return ObservableObject;
});
