﻿// <copyright file="TextBoxModel.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// 

/*
* @class TextEditModel base class for models of text edit controls (like TextBox, MemoEdit)
*/
define(['common/Enums', 'base/TextControlModel'],
function (Enums, TextControlModel) {
    //here we will define model for button


    var TextEditModel = TextControlModel.extend({

        init: function (type, parentResourceManager) {
            this._super(type, parentResourceManager);

            this.ClassName = 'TextEditModel';

        },

        getIsReadonly: function () {
            return this.get(Enums.ParameterRoles.IS_READONLY);
        },

        getMaxLength: function () {
            return this.get(Enums.ParameterRoles.MAX_LENGTH);
        },

        getKeyboardVisibility: function () {
            return this.get(Enums.ParameterRoles.KEYBOARD_VISIBILITY);
        },

        getKeyboardType: function () {
            return this.get(Enums.ParameterRoles.KEYBOARD_TYPE);
        },

        getKeyboardPosition: function () {
            return this.get(Enums.ParameterRoles.LAYOUT);
        },

        getKeyboardBinding: function () {
            return this.get(Enums.ParameterRoles.ATTACH);
        },

        getFontMultiline: function() {
            return this.get(Enums.ParameterRoles.FONT_MULTILINE);
        }
    });

    return TextEditModel;
});
