﻿
define(['common/Enums'], function (Enums) {

    var KnownGeometryProcessor = Class.extend({
        init: function () {
            this.knownGeometries = {}; //type:path pattern
            this.borderLeftWidth = 1;
            this.borderRightWidth = 1;

            this._initializeknownGeometries();
        },       

        isKnownGeometry: function (geometryPath) {
            return this.knownGeometries[geometryPath] !== undefined;
        },

        _initializeknownGeometries: function () {
            this.knownGeometries[Enums.geometryType.SVG_BORDER_OVAL] = 'm{0},{1} a {2},{3} 0 1, 0, {4}, 0 a {2},{3} 0 1, 0, -{4}, 0 z';
            this.knownGeometries[Enums.geometryType.SVG_BORDER_RECT] = 'M 0,0 L {0},0 L {0},{1} L 0,{1} Z';
        },

        process: function (geometryPath, width, height) {
            switch (geometryPath) {
                case Enums.geometryType.SVG_BORDER_OVAL:
                    var radiusX = width / 2;
                    var radiusY = height / 2;
                    return String.format(this.knownGeometries[Enums.geometryType.SVG_BORDER_OVAL],
                        this.borderLeftWidth / 2, this.borderRightWidth / 2 + radiusY,
                        radiusX, radiusY, 2 * Math.max(radiusX, radiusY));
                case Enums.geometryType.SVG_BORDER_RECT:
                    return String.format(this.knownGeometries[Enums.geometryType.SVG_BORDER_RECT],
                         width, height);
            }

            Error.warn('Known geometry unknown.');
        }
    });

    return new KnownGeometryProcessor();
});
