﻿// <copyright file="DataTableController.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// 

define(['base/ControlController',
    'common/Enums', 'common/Utilites', 'common/Appearence',
//    'js!libs/jquery_datatables_min.js!order',
    'core/ImplicitConvertations',
    'core/L10n',
    'link!controls/DataTable/styles/grid.css',
    'link!controls/DataTable/styles/layout.css'
],
    function (ControlController, Enums, Utilites, Appearence, ImplicitConvertations, L10n) {

        var DataTableController = ControlController.extend({
            init: function () {
                this._super();
                this.initialized = false;
                this.ClassName = 'DataTableController';
                $(window).on('resize', this.onScrollChanged.bind(this));
            },    

            getTable: function(){
                return this.mvc.view.$('table');
            },
            getHeaders: function () {
                return this.mvc.view.$('th');
            },
            getRows: function(){
                return this.mvc.view.$("tbody").find("tr[role='row']");
            },
            getPaginate: function(){
                return this.mvc.view.$(".dataTables_paginate");
            },
            onAddedToDOM: function () {
                this._super();
                this.initialized = true;
                this.modelChanged[Enums.ParameterRoles.PANEL_DATA_SOURCE] = this.onDataSourceChanged.bind(this);
           //     this.modelChanged[Enums.ParameterRoles.HEADER_ROW_STYLE] = this.onHeaderRowStyleChanged.bind(this);
            },

            onDestroy: function () {
                this._super();                
                this.initialized = false;
            },
            _createColumnDefs: function () {
                var columns = this.mvc.model.get(Enums.ParameterRoles.TABLE_COLUMNS);
                var result = [];
                var order_data=[];
                for (var i = 0; i < columns.length; i++) {
                    order_data[columns[i].value.SortPosition.value] = i;
                }
                for (var i = 0; i < columns.length; i++) {
                    result.push({
                        title: columns[i].value.DisplayName.value,
                        className: this._getTextAlignment(columns[i].value.HorizontalAlign.value), 
                        visible: columns[i].value.Visibility.value,
                        width: columns[i].value.ColumnWidth.value,
                        format: columns[i].value.ValueFormat.value,
                        stType: columns[i].value.FieldType.value
                        });
                }
                return result;
            },
            _createOrderData: function(){
                var columns = this.mvc.model.get(Enums.ParameterRoles.TABLE_COLUMNS);
                var order_data = [];
                for (var i = 0; i < columns.length; i++) {
                    order_data[columns[i].value.SortPosition.value] = i;
                }
                return { targets: [order_data[0]], orderData: order_data };
            },
            _getVisibility: function(visible){
                if (visible)
                    return "all";
                else
                    return "never";
            },
            _getTextAlignment: function (align) {
                var result = 'dt-body';
                switch (align) {
                    case Enums.TextHorizontalAlignment.Left:
                        return result+'-left';
                    case Enums.TextHorizontalAlignment.Right:
                        return result+'-right';
                    case Enums.TextHorizontalAlignment.Center:
                        return result+'-center';
                    case Enums.TextHorizontalAlignment.Justyfy:
                        return result+'-justify';
                    default:
                        return result+'-center';
                }
            },
            onHeaderBorderChanged: function(){
                var border = {
                    penType: Enums.BorderStyleType.Solid,
                    size: this.mvc.model.get(Enums.ParameterRoles.HEADER_ROW_STYLE)[Enums.ParameterRoles.BORDER_THIKNESS].value,
                    color: this.mvc.model.get(Enums.ParameterRoles.HEADER_ROW_STYLE)[Enums.ParameterRoles.BORDER_COLOR].value
                };
                Appearence.border.applyBorder(this.getHeaders(), border);
            },

            onHeaderHeightChanged: function(){
                if (this.mvc.model.get(Enums.ParameterRoles.HEADER_ROW_STYLE)[Enums.ParameterRoles.HEIGHT].value != "auto") {
                    this.mvc.view.$("th").attr("height", this.mvc.model.get(Enums.ParameterRoles.HEADER_ROW_STYLE)[Enums.ParameterRoles.HEIGHT].value + 'px');
                }
                this.onScrollChanged();
            },

            getControlHeightPx: function () {
                return this.mvc.view.$().outerHeight() - this.mvc.view.$(".dataTables_scrollHead").outerHeight();
            },

            onScrollChanged: function () {
                this.mvc.view.$(".dataTables_scrollBody").css('max-height', this.getControlHeightPx());
            },
           

            onDataSourceChanged: function () {
                var dataArray = this.mvc.model.get(Enums.ParameterRoles.PANEL_DATA_SOURCE);
                var messageIndex, fieldIndex;
                var messages = [];
                var messageFields = this.mvc.model._data.TableColumns.value;
                this.columns = this._createColumnDefs();
                for (messageIndex = 0; messageIndex < dataArray.length; messageIndex++) {
                    var columns = Object.keys(dataArray[messageIndex]);
                    var message = [];
                    for (fieldIndex = 0; fieldIndex < messageFields.length; fieldIndex++) {
                        var struct_col_val = messageFields[fieldIndex].value.Field.value == "" ? columns[fieldIndex] : messageFields[fieldIndex].value.Field.value;

                        var value_to_convert = {
                            value: dataArray[messageIndex][struct_col_val] | dataArray[messageIndex]['_' + struct_col_val],
                            typeName: this.columns[fieldIndex].stType
                        };
                        if (value_to_convert.typeName != "") {
                            ImplicitConvertations.convert(value_to_convert, Enums.serverType.string);
                        }
                        var converted_value = value_to_convert.value;
                        message.push(converted_value);
                    }
                    messages.push(message);
                }
                if (this.instance) { //таблица уже создана, нужно поменять содержимое
                    this.instance.clear().rows.add(messages).draw();
                    return;
                }
                var paging = this.mvc.model.get(Enums.ParameterRoles.IS_PAGED);
                var scroll;
                if (paging)
                    scroll = false;
                else
                    scroll = this.getControlHeightPx();
                this.instance = this.getTable().DataTable({
                    data: messages,
                    responsive: true,
                    columns: this.columns,
                    columnDefs: this._createOrderData(),
                    retrieve: true,
                    paging: paging,
                    ordering: false,
                    info: false,
                    searching: false,
                    scrollY: scroll,
                    deferRender:    true,
                //    scroller:       true,
                //    pageLength: 10,
                    bLengthChange : false,
                    scrollCollapse: true,
                    language: L10n.get('dataTable')
                });
                this.onScrollChanged();
                
                this.modelChanged[Enums.ParameterRoles.HEADER_ROW_STYLE + '.' + Enums.ParameterRoles.FONT_BOLD] = Appearence.text.applyTextBold.bind(this, this.getHeaders()); //без инициализации таблицы выставлять параметры бессмысленно
                this.modelChanged[Enums.ParameterRoles.HEADER_ROW_STYLE + '.' + Enums.ParameterRoles.FONT_ITALIC] = Appearence.text.applyTextItalic.bind(this, this.getHeaders());
                this.modelChanged[Enums.ParameterRoles.HEADER_ROW_STYLE + '.' + Enums.ParameterRoles.FONT_UNDERLINED] = Appearence.text.applyTextUnderline.bind(this, this.getHeaders());
                this.modelChanged[Enums.ParameterRoles.HEADER_ROW_STYLE + '.' + Enums.ParameterRoles.BORDER_THIKNESS] = this.onHeaderBorderChanged.bind(this);
                this.modelChanged[Enums.ParameterRoles.HEADER_ROW_STYLE + '.' + Enums.ParameterRoles.BORDER_COLOR] = this.onHeaderBorderChanged.bind(this);
                this.modelChanged[Enums.ParameterRoles.HEADER_ROW_STYLE + '.' + Enums.ParameterRoles.BACKGROUND_COLOR] = Appearence.background.solid.apply.bind(this, this.getHeaders());
                this.modelChanged[Enums.ParameterRoles.HEADER_ROW_STYLE + '.' + Enums.ParameterRoles.TEXT_COLOR] = Appearence.text.applyTextColor.bind(this, this.getHeaders());
                this.modelChanged[Enums.ParameterRoles.HEADER_ROW_STYLE + '.' + Enums.ParameterRoles.HEIGHT] = this.onHeaderHeightChanged.bind(this);
                this.modelChanged[Enums.ParameterRoles.HEADER_ROW_STYLE] = this.onHeaderRowStyleChanged.bind(this);
                this.onHeaderRowStyleChanged();
                var oSettings = this.instance.settings();
                if (paging) {
                    oSettings[0]._iDisplayLength = Math.floor((this.mvc.view.$().height() - this.getHeaders().height()-this.getPaginate().height())/(this.getRows().height())-1);
                } /*else {
                    oSettings[0].oScroll.sY = this.mvc.view.$().height() - this.getHeaders().height();
                }*/
                this.instance.draw();
            },
            onHeaderRowStyleChanged: function () {
                this.modelChanged[Enums.ParameterRoles.HEADER_ROW_STYLE + '.' + Enums.ParameterRoles.FONT_BOLD](this.mvc.model.get(Enums.ParameterRoles.HEADER_ROW_STYLE + '.' + Enums.ParameterRoles.FONT_BOLD));
                this.modelChanged[Enums.ParameterRoles.HEADER_ROW_STYLE + '.' + Enums.ParameterRoles.FONT_ITALIC](this.mvc.model.get(Enums.ParameterRoles.HEADER_ROW_STYLE + '.' + Enums.ParameterRoles.FONT_ITALIC));
                this.modelChanged[Enums.ParameterRoles.HEADER_ROW_STYLE + '.' + Enums.ParameterRoles.FONT_UNDERLINED](this.mvc.model.get(Enums.ParameterRoles.HEADER_ROW_STYLE + '.' + Enums.ParameterRoles.FONT_UNDERLINED));
                this.modelChanged[Enums.ParameterRoles.HEADER_ROW_STYLE + '.' + Enums.ParameterRoles.BORDER_THIKNESS](this.mvc.model.get(Enums.ParameterRoles.HEADER_ROW_STYLE + '.' + Enums.ParameterRoles.BORDER_THIKNESS));
                this.modelChanged[Enums.ParameterRoles.HEADER_ROW_STYLE + '.' + Enums.ParameterRoles.BORDER_COLOR](this.mvc.model.get(Enums.ParameterRoles.HEADER_ROW_STYLE + '.' + Enums.ParameterRoles.BORDER_COLOR));
                this.modelChanged[Enums.ParameterRoles.HEADER_ROW_STYLE + '.' + Enums.ParameterRoles.BACKGROUND_COLOR](this.mvc.model.get(Enums.ParameterRoles.HEADER_ROW_STYLE + '.' + Enums.ParameterRoles.BACKGROUND_COLOR));
                this.modelChanged[Enums.ParameterRoles.HEADER_ROW_STYLE + '.' + Enums.ParameterRoles.TEXT_COLOR](this.mvc.model.get(Enums.ParameterRoles.HEADER_ROW_STYLE + '.' + Enums.ParameterRoles.TEXT_COLOR));
                this.modelChanged[Enums.ParameterRoles.HEADER_ROW_STYLE + '.' + Enums.ParameterRoles.HEIGHT](this.mvc.model.get(Enums.ParameterRoles.HEADER_ROW_STYLE + '.' + Enums.ParameterRoles.HEIGHT));
            }
        });

        return DataTableController;
    });
