﻿// <copyright file="DateTimePickerModel.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// 

define(['common/Enums', 'base/TextControlModel', 'common/Error'],
function (Enums, TextControlModel, Error) {
    //here we will define model for button TextControlModel


    var DateTimePickerModel = TextControlModel.extend({
        dateTimeSeparator: ' ',

        init: function (type, parentResourceManager) {
            this._super(type, parentResourceManager);

            this.ClassName = 'DateTimePickerModel';

        },

        getDateTime: function () {
            return this.get(Enums.ParameterRoles.DATE_TIME);
        },

        setDateTime: function (value) {
            this.set(Enums.ParameterRoles.DATE_TIME, +value);
        },

        getDateTimeType: function () {
            return this.get(Enums.ParameterRoles.DATE_TIME_TYPE);
        },

        getDateFormat: function () {
            var dateFormat = this.get(Enums.ParameterRoles.DATE_FORMAT);
            if (!dateFormat) {
                return "MM/dd/yyyy";
            }
            return dateFormat;
        },

        getTimeFormat: function () {            
            var timeFormat = this.get(Enums.ParameterRoles.TIME_FORMAT);
            if (!timeFormat) {
                return "HH:mm:ss";
            }

            return timeFormat;
        },

        getDateTimeFormat: function()
        {
            var pickerType = this.get(Enums.ParameterRoles.DATE_TIME_TYPE);
            switch (pickerType) {
                case Enums.DateTimeType.Date_Type:
                    return this.getDateFormat();
                case Enums.DateTimeType.Time_Type:
                    return this.getTimeFormat();
                case Enums.DateTimeType.DateTime_Type:
                    return this.getDateFormat() + this.dateTimeSeparator + this.getTimeFormat();
                case Enums.DateTimeType.TimeDate_Type:
                    return this.getTimeFormat() + this.dateTimeSeparator + this.getDateFormat();
                default:
                    Error.warn(String.format('Unknown picker type {0}. Date format will be used.', pickerType));
                    return this.getDateFormat();
            }
        },

        getPickerType: function () {
            var pickerType = this.get(Enums.ParameterRoles.DATE_TIME_TYPE);
            switch (pickerType) {
                case Enums.DateTimeType.Date_Type:
                    return 'date';
                case Enums.DateTimeType.Time_Type:
                    return 'time';
                case Enums.DateTimeType.DateTime_Type:
                    return 'datetime';
                case Enums.DateTimeType.TimeDate_Type:
                    return 'timedate';
                default:
                    Error.warn(String.format('Unknown picker type {0}. Date picker will be used.', pickerType));
                    return 'date';
            }
        },

        getIsReadOnly: function () {
            return this.get(Enums.ParameterRoles.IS_READONLY);
        }
    });

    return DateTimePickerModel;
});
