﻿
define(['base/EventTarget'], function (EventTarget) {

    var ModulesProvider = EventTarget.extend({
        MODULES_PROVIDER_READY: 'ModulesProviderReady',
        init: function () {
            this._listeners = {};
            this._listeners[this.MODULES_PROVIDER_READY] = [];
            this.loadedCount = 0;
            this.modules = {
                controlFactory: undefined,
                l10n: undefined,
                Error: undefined
            };
            this.modulesCount = Object.keys(this.modules).length;
        },

        loadModules: function () {
            curl(['controls/ControlFactory'], function (cf) {
                this.modules.controlFactory = cf;
                this._onModuleLoaded();
            }.bind(this));

            curl(['core/L10n'], function (l10n) {
                this.modules.l10n = l10n;
                this._onModuleLoaded();
            }.bind(this));

            curl(['common/Error'], function (Error) {
                this.modules.Error = Error;
                this._onModuleLoaded();
            }.bind(this));
        },

        _onModuleLoaded: function () {
            this.loadedCount++;
            if (this.loadedCount === this.modulesCount) {
                this.fireProviderReady();
            }
        },

        getControlFactory: function () {
            return this.modules.controlFactory;
        },

        getError: function () {
            return this.modules.Error;
        },
         
        subscribeProviderReady: function (handler, context) {
            this.bindOnce(this.MODULES_PROVIDER_READY, handler, context);
        },

        fireProviderReady: function () {
            this.fire({
                type: this.MODULES_PROVIDER_READY,
                target: this               
            });
        }

    });

    var instance = new ModulesProvider();

    return instance;
});