/** 
	* @class Timer
	* @classdesc
	
	*/
define(['common/Error'], function (error) {
    /** 
	* Creates an Timer object
	* @constructor
	* @this {Timer}
	*/
    var Timer = Class.extend({
        init: function (interval) {
            this.interval = interval;
            this.actions = [];
            this.started = false;
            this.actionIndex = 0;
            this.refreshFunc = this.refresh.bind(this);
            this.getActionsBind = this.getActions.bind(this);
        },

        append: function (action) {
            this.actions.push(action);
        },

        prepend: function (action) {
            this.actions.unshift(action);
        },

        remove: function (action) {
            var index = this.actions.indexOf(action);
            if (index !== -1) {
                this.actions.splice(index, 1);
            } else {
                console.log('Timer: action not found');
            }
        },

        getActions: function () {
            if (this.started) {
                if (this.actions.length > 0) {
                    try {
                        var promise = this.actions[0]();
                        for (var i = 1; i < this.actions.length; i++)
                            promise = promise.then(this.actions[i], this.actions[i]);
                        promise.then(this.refreshFunc, this.refreshFunc);
                    } catch (e) {
                        error.exception(e);
                        this.refreshFunc();
                    }
                } else {
                    this.refreshFunc();
                }
            }
        },

        start: function () {
            this.started = true;
            this.refresh();
        },

        refresh: function () {
            if (this.started === true) {
                clearTimeout(this.timerId);
                this.timerId = setTimeout(this.getActionsBind, this.interval);
            }
        },

        stop: function () {
            clearInterval(this.timerId);
            this.started = false;
        },

        setInterval: function (interval) {
            this.interval = interval;
        }
    });

    return Timer;
});