﻿// <copyright file="Condition.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// 

define(['common/Enums', 'common/Utilites', 'base/Model', 'core/ImplicitConvertations'], function (Enums, Utilites, Model, ImplicitConvertations) {
    var CONDITION_STATE_CHANGED = 'ConditionStateChanged';

    var Condition = Model.extend({

        init: function (options, conditionsDictionary, conditionFactory) {
            this._super();

            this._data = {
                compareWith: null,
                operand: null
            };

            this.childConditions = [];

            this.id = options.id;
            this.ClassName = 'Condition' + this.id;
            this.comparer = options.comparer;
            this.type = options.type;

            this._data.operand = $.extend(true, {}, options.operand);
            this._data.compareWith = $.extend(true, {}, options.compareWith);

            conditionsDictionary[this.id] = this;

            var i;
            for (i = 0; i < options.conditions.length; i++) {
                var conditionCtor = conditionFactory.getByType(options.conditions[i].type);
                var condition = new conditionCtor(options.conditions[i], conditionsDictionary, conditionFactory);
                this.childConditions.push(condition);
                condition.subscribeConditionStateChanged(this.onConditionStateChanged, this);
            }

            this.subscribePropertyChanged(this.onConditionStateChanged, this);
        },

        getState: function () {
            //при первом запросе вычесляем состояние
            if (this.state == undefined) {
                this.updateState();
            }

            return this.state;
        },

        updateState: function() {   //пересчет с учетом всех вложенных условий
            //если есть хотя бы одно подусловие - то ставим false
            //по ИЛИ оно сможет переставить в true
            //если нету - то ставим true, иначе всегда будет false
            var i, newState = this.childConditions.length == 0;
            for (i = 0; i < this.childConditions.length; i++) {
                newState = newState || this.childConditions[i].getState(); // (Conditions[0].Result || Conditions[1].Result || Conditions[2].Result....)
            }
            //bool result = This.Result && (Conditions[0].Result || Conditions[1].Result || Conditions[2].Result....)
            this.state = this.checkCurrentCondition() && newState;
        },

        onConditionStateChanged: function () {
            var oldState = this.state;
            this.updateState();
            if(oldState !== this.state) {
                this.fireConditionStateChanged();
            }
        },

        checkCurrentCondition: function () {
            var operand = _.clone(this._data.operand);
            var compareWith = _.clone(this._data.compareWith);
            ImplicitConvertations.convert(operand, compareWith.typeName); //need to compare same types
            if (operand.typeName == "BOOL" && compareWith.typeName == "STRING")
                compareWith.value = compareWith.value.toLowerCase();
            var compareResult = Utilites.compare(operand.value, compareWith.value);
            switch (this.comparer) {
                case Enums.ComparerType.more:
                    return compareResult == 1;
                case Enums.ComparerType.less:
                    return compareResult == -1;
                case Enums.ComparerType.lessEqual:
                    return compareResult < 1;
                case Enums.ComparerType.moreEqual:
                    return compareResult >= 0;
                case Enums.ComparerType.equal:
                    return compareResult == 0;
                case Enums.ComparerType.notEqual:
                    return compareResult != 0;
            }
        },

        subscribeConditionStateChanged: function (handler, context) {
            this.eventTarget.addListener(CONDITION_STATE_CHANGED, handler, context);
        },

        fireConditionStateChanged: function () {
            this.eventTarget.fire({ type: CONDITION_STATE_CHANGED, target: this });
        }
    });

    return Condition;
})