﻿// <copyright file="VariablesManager.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// 


define(['common/Enums', 'common/Error',
    'server/sources/SourcesSettings',
    'server/HeartbeatManager',
    'core/global/GlobalEvents',
    'server/TrendVariablesManager',
    'server/ShemeVariablesManager', 'server/jsonVariablesManager/SchemeJsonVariablesManager', 'server/adapters/JSONAdapter'
],
    function (Enums, Error, SourcesSettings, HeartbeatManager, GlobalEvents, TrendVariablesManager, ShemeVariablesManager, SchemeJsonVariablesManager, JSONAdapter) {

        var VariablesManagersHandler = Class.extend({
            init: function () {
                this.settings = {}; //dataSourceId : {uri, interval, type}   
                this.variablesManagers = {}; //dataSourceId : VM object  
                this.variablesManagersErrors = {}; //vmId : IsError  
                this.settings = SourcesSettings;               
            },

            addSettings: function (settings) {
                $.extend(this.settings, settings);
            },

            initialize: function(){                
                this.heartbeatManager = new HeartbeatManager();
                this.heartbeatManager.subscribeServerErrorStateChanged(this._onVMServerErrorStateChanged, this);
                this.heartbeatManager.initInternal();
            },

            get: function (id, ownerId, subType) {
                var vmId = ownerId + '_' + id;
                if (this.variablesManagers[vmId] === undefined || this.variablesManagers[vmId].subType !== subType) {
                    var type = this.settings[id].type;                    
                    this.variablesManagers[vmId] = this._createVMByType(type, subType, this.settings[id]);
                    this.variablesManagers[vmId].type = type;
                    this.variablesManagers[vmId].subType = subType; //различать тренд и схему
                    this.variablesManagers[vmId].subscribeServerErrorStateChanged(this._onVMServerErrorStateChanged, this);
                    //this.variablesManagers[id].setOptions(this.settings[id]);
                }

                return this.variablesManagers[vmId];
            },

            //for scheme, windows
            _createVMByType: function (type, subType, options) {
                switch (type) {
                    case Enums.variablesManagersTypes.json:
                        return this._createRest(subType, options);
                    case Enums.variablesManagersTypes.masterPLC:
                        return this._createMasterPLC(subType, options);
                    default:
                        Error.onerror('Unknown variables manager type: ' + type);
                        break;
                }
            },

            _createRest: function (subType, options) {
                switch (subType) {
                case Enums.variablesManagersSubTypes.scheme:
                    return new SchemeJsonVariablesManager(options, JSONAdapter);
                case Enums.variablesManagersSubTypes.trend: //TODO
                    return new TrendVariablesManager(options);
                default:
                    Error.onerror('Unknown variables manager subtype: ' + subType);
                }
            },
            _createMasterPLC: function (subType, options) {
                switch (subType) {
                    case Enums.variablesManagersSubTypes.scheme:
                        return new ShemeVariablesManager(options);
                    case Enums.variablesManagersSubTypes.trend:
                        return new TrendVariablesManager(options);
                    default:
                        Error.onerror('Unknown variables manager subtype: ' + subType);
                }
            },

            _onVMServerErrorStateChanged: function (event) {
                if (event.isError === true) {
                    this.variablesManagersErrors[event.vmId] = event.isError;
                    GlobalEvents.fire({ type: Enums.GlobalEventsTypes.offline });
                } else {
                    delete this.variablesManagersErrors[event.vmId];
                    if (Object.keys(this.variablesManagersErrors).length === 0) {
                        GlobalEvents.fire({ type: Enums.GlobalEventsTypes.online });                        
                    }
                }
            }
        });

        var instance = new VariablesManagersHandler();

        return instance;
    });