﻿define(['common/Enums', 'common/Error', 'common/GeometryNormalizer/Processor/PathCommands/PathSyntaxCommand',
  'common/GeometryNormalizer/Processor/PathSyntaxCommandElement'],
    function (Enums, Error, PathSyntaxCommand, PathSyntaxCommandElement) {
        var CubicBezierCurveCommand = PathSyntaxCommand.extend({

            parse: function (args) {
                var tempArray = this._splitPath(args);
                var argsCount = this._getArgsCount();
                var i;
                for (i = 0; i < tempArray.length - (argsCount - 1) ; i += argsCount) {
                    var c1x = new PathSyntaxCommandElement(Enums.pathSyntaxCommandElementType.X, tempArray[i]);
                    var c1y = new PathSyntaxCommandElement(Enums.pathSyntaxCommandElementType.Y, tempArray[i + 1]);
                    var c2x = new PathSyntaxCommandElement(Enums.pathSyntaxCommandElementType.X,  tempArray[i + 2]);
                    var c2y = new PathSyntaxCommandElement(Enums.pathSyntaxCommandElementType.Y,  tempArray[i + 3]);
                    var c3x = new PathSyntaxCommandElement(Enums.pathSyntaxCommandElementType.X,  tempArray[i + 4]);
                    var c3y = new PathSyntaxCommandElement(Enums.pathSyntaxCommandElementType.Y,  tempArray[i + 5]);

                    this.elements.push(c1x);
                    this.elements.push(c1y);
                    this.elements.push(c2x);
                    this.elements.push(c2y);
                    this.elements.push(c3x);
                    this.elements.push(c3y);
                }
            },

            getPattern: function () {
                return ' {0},{1} {2},{3} {4},{5} ';
            },

            getCommand: function () {
                return Enums.pathCommand.C;
            },
        });

        return CubicBezierCurveCommand;
    });