﻿// <copyright file="ClockController.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright> 

/*
* @class CustomSvgController controller class for Svg control
*/
define(['base/ControlController', 'common/Utilites', 'core/Statistic', 'common/Error'], function (ControlController, Utilites, Statistic, Error) {
    return ControlController.extend({

        init: function () {
            this._super();
            this.ClassName = 'CustomSvgController';
            this.svgRoot = null;
        },

        onAddedToDOM: function () {
            this._super();
            if (Utilites.isWebkit() && !Utilites.isTablet()) {
                $(window).on('resize', this, this.onResize.bind(this));
            }
        },
        loadSVG: function () {
            var embed;
            if (this.mvc.model.hasConnections) {
                embed = this.mvc.view.$()[0];
                try {
                    embed.getSVGDocument();
                } catch (ex) {
                    console.error(ex.message || ex);
                }
                embed.addEventListener('load',
                    function() {
                        Statistic.addEmbedCount();
                        this.svgRoot = this._getSvgRoot(embed);
                        if (this.svgRoot) { //бывает возвращается null
                            this.initSvgModelChangedMethods();
                            this.addSvgEventListener.call(this, this.svgRoot);
                        } else {
                            Error.warn("svg DataControlId = " + this.mvc.model.getId() + " getSVGDocument=null");
                        }
                    }.bind(this),
                    { capture: false, once: true });
                return;
            }
            this.addSvgEventListener.call(this, embed);
        },

        attachEvents: function () {
            this.loadSVG();
        },

        addSvgEventListener: function (embed) {
            var elem = $(embed);
            this.addEvents(elem);
        },

        initSvgModelChangedMethods: function () {
            var data = this.mvc.model._data;
            for (var dataKey in data) {
                if (dataKey.indexOf('svg:') >= 0) {
                    this.modelChanged[dataKey] = this._setSvgParameter.bind(this, dataKey);
                    this._setSvgParameter(dataKey, this.mvc.model.get(dataKey));
                }
            }
        },
        modelPropertyChangedInternal: function (event) {
            this._super(event);
            // path in format svg:id_of_element:property name
            if (event.property.indexOf('svg:') >= 0) {
                this._setSvgParameter(event.property, this.mvc.model.get(event.property));
            }
        },

        applyShadow: function () {
            var shadow = {
                size: this.mvc.model.getShadowSize(),
                color: this.mvc.model.getShadowColor()
            };
            var gray = this.mvc.model.getIsEnabled() ? 0: 100;
            this.mvc.view.$().css('filter', String.format('drop-shadow({0}px {0}px {1}px {2}) grayscale({3}%)', shadow.size, 0, shadow.color, gray));
        },

        onIsEnabledChanged: function (value) {
            this._super();
            this.applyShadow();
        },
        onResourceChanged: function (value) {
            //get resource url
            var resourceUrl;
            if (!value) {
                resourceUrl = null;
            }
            else {
                resourceUrl = this.mvc.model.resourceManager.resolve(value);
            }
            this.mvc.view.$().attr('src', resourceUrl);
        },

        onRender: function() {
            
        }
    });
});
