﻿// <copyright file="SliderController.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// 

/*
* @class ProgressBarController controller class for ProgressBar control
*/

define(['common/Enums', 'common/Appearence', 'base/RangeControlController'],
function (Enums, Appearence, RangeControlController) {
    //here we will define controller for ProgressBar

    var ProgressBarController = RangeControlController.extend({

        currentOrientation: null,

        init: function () {
            this._super();

            this.ClassName = 'ProgressBarController';
        },

        onModelInit: function () {
            this._super();

            this.initProgressBar();
        },

        initProgressBar: function () {
            this.currentOrientation = this.mvc.model.getOrientation();

            var self = this;

            this.mvc.view.$().progressbar({
                orientation: controlOrientation(this.currentOrientation),
                max: this.mvc.model.getMaxValue() - this.mvc.model.getMinValue(),
                value: this.mvc.model.getValue() - this.mvc.model.getMinValue(),
                disabled: !this.mvc.model.getIsEnabled(),
                change: function (event, ui) { self.onChange(event, ui); }
            });

            this.applyForeColor(this.mvc.model.get(Enums.ParameterRoles.FILL_COLOR));
        },

        applyForeColor: function (value) {
            if (!Appearence.color.isColor(value)) {
                return;
            }

            this.mvc.view.$('.ui-progressbar-value')
                .css('background-color', Appearence.color.toCssColor(value));
        },

        onValueChanged: function (value) {
            this.settingValue = true;

            var newValue = value - this.mvc.model.getMinValue();
            this.mvc.view.$().progressbar("option", "value", newValue);

            this.settingValue = false;
        },

        onMinValueChanged: function (value) {
            var newValue = this.mvc.model.getValue() - value;
            var newMaxValue = this.mvc.model.getMaxValue() - value;

            this.mvc.view.$().progressbar("option", "value", newValue);
            this.mvc.view.$().progressbar("option", "max", newMaxValue);
        },

        onMaxValueChanged: function (value) {
            var newMaxValue = value - this.mvc.model.getMinValue();

            this.mvc.view.$().progressbar("option", "max", newMaxValue);
        },

        onOrientationChanged: function (value) {
            if (this.currentOrientation !== value) {

                this.mvc.view.$().progressbar("destroy");

                this.initProgressBar();
            }
        },

        onForeColorChanged: function (value) {
            this.applyForeColor(value);
        },

        onIsEnabledChanged: function (value) {
            this._super(value);

            if (value) {
                this.mvc.view.$().progressbar('enable');
            }
            else {
                this.mvc.view.$().progressbar('disable');
            }
        },

        //
        // Events
        //      

        onChange: function (event, ui) {

            if (this.settingValue) {
                return;
            }

            this.mvc.model.setValue(ui.value + this.mvc.model.getMinValue());
        },
    });

    /*
    * @method sliderOrientation returns slider orientation by enum
    */
    function controlOrientation(orientation) {
        return orientation === Enums.OrientationType.Horizontal ?
            'horizontal' : 'vertical';
    }

    return ProgressBarController;
});
