﻿// <copyright file="TrendModel.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// 

/*
* @class TrendModel model class for Trend control
*/
define(['common/ParameterRoles', 'base/ControlModel', 'common/Appearence'],
    function (Role, ControlModel, Appearence) {
        return ControlModel.extend({

            init: function (type, parentResourceManager) {
                this._super(type, parentResourceManager);
                this.ClassName = 'TrendModel';
            },

            getPens: function () {
                return this.get(Role.TREND_LINES) || [];
            },

            getPen: function (index) {
                return this.getPens()[index].value;
            },

            getPenYFormat: function (index) {
                return this.getPen(index)[Role.Y_FORMAT].value || "f3";
            },
            getOriginalPenYFormat: function(index) {
                return this.getPen(index)[Role.Y_FORMAT].value;
            },
            getPenColor: function (index) {
                return this.getPen(index)[Role.COLOR].value;
            },
            getPenName: function (index) {
                return this.getPen(index)[Role.NAME].value;
            },
            getPenMin: function (index) {
                return this.getPen(index)[Role.MIN_Y].value;
            },
            getPenMax: function (index) {
                return this.getPen(index)[Role.MAX_Y].value;
            },
            getPenLineStyle: function (index) {
                return this.getPen(index)[Role.BORDER_STYLE].value;
            },
            getPenLineJoin: function (index) {
                return this.getPen(index)[Role.LINE_JOIN].value;
            },
            getIntervalTurn: function () {
                return this.get(Role.INTERVAL_PAGES_TURN);
            },
            getPenAutoScale: function (index) {
                return this.getPen(index)[Role.AUTOSCALE].value;
            },
            getIsAutoScroll: function () {
                return this.get(Role.AUTOSCROLL);
            },

            stopAutoscroll: function () {
                if (this.getIsAutoScroll())
                    this.set(Role.AUTOSCROLL, false);
            },

            getFreezeCursor: function () {
                return this.get(Role.FREEZE_CURSOR);
            },

            getInterval: function () {
                return this.get(Role.INTERVAL);
            },

            setInterval: function (value) {
                if (value <= 0) {
                    value = 100;
                }
                this.previousInterval = this.getInterval();
                return this.set(Role.INTERVAL, value);
            },
            getTill: function () {
                return this.get(Role.TILL);
            },
            resetInterval: function (interval) {
                if (this.previousInterval !== 0) {
                    return this.set(Role.INTERVAL, interval);
                }
            },

            enableAutoscroll: function () {
                this.set(Role.AUTOSCROLL, true);
            },

            setProperty: function (name, newProperty, silent, force) {
                if ((name.indexOf("DataSource") == -1) || (newProperty.typeName == "STRING")) //либо это не перо, либо стринговое перо
                    this._super(name, newProperty, silent, true);
            },
            getGridLineThicknessOption: function (value) {
                var option = {};
                _.set(option, "xAxis.splitLine.lineStyle.width", value);
                _.set(option, "yAxis.splitLine.lineStyle.width", value);
                return option;
            },

            getGridLineStrokeColorOption: function (value) {
                var option = {};
                _.set(option, "xAxis.splitLine.lineStyle.color", value);
                _.set(option, "yAxis.splitLine.lineStyle.color", value);
                return option;
            },
            getChartBackgroundOption: function(value) {
                var option = {};
                _.set(option, "grid.backgroundColor", value);
                _.set(option, "visualMap[0].outOfRange.color", value);
                return option;
            },
            getTextColorOption: function (value) {
                var option = {};
                var value = Appearence.color.toCssColor(this.get(Role.TEXT_COLOR));
                _.set(option, "title.textStyle.color", value);
                _.set(option, "xAxis.axisLabel.color", value);
                if (this.get(Role.AUTO_SCALE) == true) {
                    _.set(option, "yAxis.axisLabel.color", value);
                }
                _.set(option, "xAxis.nameTextStyle.color", value);
                _.set(option, "yAxis.nameTextStyle.color", value);
                return option;
            },
            getMarkAreaOption: function (element) {
                var markareadata = [];
                for (var i = 0; i < element.value.PenLimits.value.length-1; i++) { //когда-нибудь здесь будет шкала
                    if (element.value.PenLimits.value[0].value.IsVisible.value) {
                        if (i == 0) {
                            markareadata.push([
                                {
                                    name: '', //это должно быть Название границы пера, но она не передается в модель
                                    yAxis: +element.value.PenLimits.value[0].value.DataSource.value,
                                    itemStyle: {
                                        normal: {
                                            color: element.value.PenLimits.value[i].value.BackgroundColor.value
                                        }
                                    }
                                },
                                {
                                    yAxis: +element.value.PenLimits.value[i].value.DataSource.value
                                }
                            ]);
                        } else {
                            markareadata.push([
                                {
                                    name: '', //это должно быть Название границы пера, но она не передается в модель
                                    itemStyle: {
                                        normal: {
                                            color: element.value.PenLimits.value[i].value.BackgroundColor.value
                                        }
                                    }
                                },
                                {
                                    yAxis: +element.value.PenLimits.value[i].value.DataSource.value
                                }
                            ]);
                        }
                        markareadata.push(
                            [
                                {
                                    name: '',
                                    yAxis: +element.value.PenLimits.value[i].value.DataSource.value,
                                    itemStyle: {
                                        normal: {
                                            color: element.value.PenLimits.value[i + 1].value.BackgroundColor.value
                                        }
                                    }
                                }, {
                                    yAxis: +element.value.PenLimits.value[i + 1].value.DataSource.value
                                }
                            ]);
                    }
                }
                return markareadata;
            },

            getMultiAxisOption: function() {
                var ctx = this;
                var y_axises = [];
                this.getPens().forEach(function(element, index) {

                    ctx.drawConstants = [];
                    var minY, maxY;
                    if (element.value.Autoscale.value) {
                        minY = null;
                        maxY = null;
                    } else {
                        minY = element.value.MinY.value;
                        maxY = element.value.MaxY.value;
                    }
                    y_axises.push({
                        type: 'value',
                        name: ctx.get(Role.Y_AXIS_LABEL),
                        min: minY,
                        max: maxY,
                        position: 'left',
                        offset: 30 * index,
                        splitNumber: element.value.TickCountY.value,
                        splitLine: {
                            lineStyle: {
                                color: ctx.get(Role.GRID_LINE_FILL_COLOR),
                                width: ctx.get(Role.GRID_LINE_THICKNESS)
                            }
                        },
                        axisLine: {
                            lineStyle: {
                                color: element.value.Color.value,
                                width: ctx.get(Role.Y_AXIS_THICKNESS)
                            }
                        },
                        axisTick: {
                            lineStyle: {
                                width: ctx.get(Role.Y_MAJOR_TICK_HEIGHT),
                                color: ctx.get(Role.Y_MAJOR_TICK_COLOR)
                            },
                            length: ctx.get(Role.Y_MAJOR_TICK_WIDTH)
                        },
                        axisLabel: {
                            formatter: function (value) {
                                return String.format('{0:' + ctx.getOriginalPenYFormat(index) + '}', value);
                            },
                            padding: + ctx.get(Role.Y_MAJOR_TICK_PADDING_RIGHT)
                        },
                        nameTextStyle: {
                            color: ctx.get(Role.TEXT_COLOR)
                        }
                    });
                });
                return y_axises;
            },
            getSeriesOption: function () {
                this.series = [];
                this.series_names = {};
                var ctx = this;
                if (this.getPens().length !== 0) {
                    this.getPens().forEach(function (element, index) {
                        ctx.drawConstants = [];
                        ctx.series.push({
                            name: element.value.Name.value,
                            yAxisIndex: index,
                            type: 'line',
                            showSymbol: false,
                            itemStyle: {
                                normal: {
                                    show: true,
                                    color: element.value.Color.value
                                },
                                emphasis: {
                                    show: true,
                                    symbolSize: 1
                                }
                            },

                            lineStyle: {
                                normal: {
                                    color: element.value.Color.value,
                                    width: element.value.Thickness.value,
                                    type: Appearence.border.getBorderStyle(element.value.LineStyle.value)
                                },
                                emphasis: {
                                    width: element.value.Thickness.value + 3,
                                    shadowBlur: 10
                                }
                            },
                            step: element.value.LineJoin.value ? "end": false,
                            //     sampling: 'average',
                            markArea: {
                                label: {
                                    normal: {
                                        position: ['10%', '50%']
                                    }
                                },
                                silent: true,
                                data: ctx.getMarkAreaOption(element)
                            },
                            data: []
                        });
                        ctx.series_names[element.value.Name.value] = {};
                        ctx.series_names[element.value.Name.value].idx = index;
                        ctx.series_names[element.value.Name.value].unit = element.value.Unit.value;
                        if (element.value.DrawConstant.value) {
                            ctx.drawConstants.push(index);
                        }
                    });

                }
                return this.series;
            },

            getInitialChartOption: function () {
                this.current_y_axis = this.getMultiAxisOption();
                if (!this.current_y_axis.length)
                    this.current_y_axis = {};
                return {
                    toolbox: {
                        itemSize: 25,
                        showTitle: true,
                        right: 'left',
                        left: 'left',
                        feature: {
                            dataZoom: {
                                yAxisIndex: 'none',
                                title: {
                                    zoom: 'масштабирование',
                                    back: 'вернуть назад'
                                }
                            },
                            dataView: {
                                readOnly: true,
                                title: 'таблица\nданных',
                                lang: ['Таблица данных', 'назад', 'обновить'],
                                optionToContent: function(opt) {
                                    var series = opt.series;
                                    var i, j;
                                    var iterators = Array(series.length);
                                    var resultTable = [];
                                    _.fill(iterators, 0);
                                    var notTheEnd = true;
                                    resultTable.push(["Время"]);
                                    for (i = 0; i < series.length; i++) {
                                        _.last(resultTable).push(series[i].name);
                                    }
                                    while (notTheEnd) {
                                        resultTable.push(Array(series.length + 1));
                                        _.fill(_.last(resultTable), '-');
                                        var min = undefined;
                                        for (i = 0; i < iterators.length; i++) {
                                            if (series[i].data[iterators[i]] &&
                                                (series[i].data[iterators[i]][0] < min || min == undefined)) {
                                                min = series[i].data[iterators[i]][0];
                                            }
                                        }
                                        _.last(resultTable)[0] = String.format('{0:' + this.get(Role.X_AXIS_FORMAT) + '}', new Date(min)); //присваиваем время
                                        notTheEnd = false;
                                        for (i = 0; i < iterators.length; i++) {
                                            if (series[i].data[iterators[i]]) {
                                                if (series[i].data[iterators[i]][0] == min) {
                                                    _.last(resultTable)[i + 1] =
                                                        String.format('{0:' + this.getPenYFormat(i) + '}', series[i].data[iterators[i]][1]);
                                                    iterators[i]++;
                                                } else if (iterators[i] > 0) {
                                                    _.last(resultTable)[i + 1] =
                                                        String.format('{0:' + this.getPenYFormat(i) + '}', series[i].data[iterators[i] - 1][1]);
                                                }
                                                notTheEnd = true;
                                            }
                                        }
                                    }
                                    resultTable.pop();
                                    var table = '<table style="width:100%;text-align:center"><tbody>';
                                    for (i = 0; i < resultTable.length; i++) {
                                        table += "<tr>";
                                        for (j = 0; j < resultTable[i].length; j++) {
                                            table += "<td>" + resultTable[i][j] + "</td>";
                                        }
                                        table += "</tr>";
                                    }
                                    table += '</tbody></table>';
                                    return table;
                                }.bind(this)
                            },
                            saveAsImage: {
                                title: 'сохранить\npng',
                                pixelRatio: 3
                            }
                        }
                    },
                    title: {
                        text: this.get(Role.TITLE),
                        textStyle: {
                            color: this.get(Role.TEXT_COLOR)
                        },
                        left: 'center'
                    },
                    dataZoom: [
                        {
                            type: 'inside',
                            realtime: true,
                            showDetail: true
                        }, {
                            handleSize: '80%',
                            backgroundColor: '#F5F5F5',
                            dataBackground: {
                                lineStyle: {
                                    color: '#F5F5F5'
                                },
                                areaStyle: {
                                    color: '#F5F5F5'
                                }
                            }
                        }
                    ],
                    legend: {
                        orient: 'vertical',
                        left: 'right',
                        top: 'top',
                        align: 'left',
                        padding: 10,
                        itemGap: 10,
                        borderWidth: 1,
                        selectedMode: 'multiple',
                        backgroundColor: '#eeeeee',
                        data: Object.keys(this.series_names),
                        silent: false,
                        formatter: function(name) {
                            if (this.series_names[name].lastValue && !isNaN(this.series_names[name].lastValue))
                                return name +
                                    "  " +
                                    String.format('{0:' + this.getPenYFormat(this.series_names[name].idx) + '}',
                                        Number(this.series_names[name].lastValue)) +
                                    " " +
                                    this.series_names[name].unit;
                            else
                                return name;
                        }.bind(this)
                    },
                    tooltip: {
                        trigger: 'axis',
                        axisPointer: {
                            show: true,
                            animation: false
                        },
                        formatter: function (params) {
                            var result = "";
                            params = _.uniqBy(params, 'seriesName');
                            for (var i = 0; i < params.length; i++) {
                                result += params[i].seriesName +
                                    ': ' +
                                    String.format(
                                        '{0:' + this.getPenYFormat(this.series_names[params[i].seriesName].idx) + '}',
                                        params[i].value[1]) +
                                    '<br>';
                            }
                            return result;
                        }.bind(this)
                    },
                    grid: {
                        show: true,
                        backgroundColor: this.get(Role.CHART_BACKGROUND)
                    },
                    xAxis: {
                        type: 'time',
                        boundaryGap: false,
                        triggerEvent: true,
                        silent: false,
                        min: this.startTime,
                        max: this.endTime,
                        offset: this.get(Role.X_MAJOR_TICK_PADDING_TOP),
                        splitNumber:
                        this.get(Role.X_MAJOR_TICK_COUNT), //среднее число засечек, на практике может быть и больше, и меньше
                        axisPointer: {
                            show: true,
                            lineStyle: {
                                color: this.get(Role.CURSOR_COLOR),
                                opacity: 0.5,
                                width: this.get(Role.CURSOR_THICKNESS)
                            },
                            label: {
                                show: true,
                                formatter: function (params) {
                                    return echarts.format.formatTime('hh:mm:ss', params.value);
                                },
                                backgroundColor: '#004E52'
                            },
                            handle: {
                                size: 15,
                                color: '#00ff11'
                            }
                        },
                        axisLine: {
                            lineStyle: {
                                width: this.get(Role.X_AXIS_THICKNESS),
                                color: this.get(Role.X_AXIS_STROKE_COLOR)
                            }
                        },
                        nameTextStyle: {
                            color: this.get(Role.TEXT_COLOR)
                        },
                        axisLabel: {
                            color: this.get(Role.TEXT_COLOR),
                            formatter: function(value, index) {
                                return String.format('{0:' +
                                    this.get(Role.X_AXIS_FORMAT) +
                                    '}',
                                    new Date(value));
                            }
                                .bind(this)
                        },
                        splitLine: {
                            show: true,
                            lineStyle: {
                                color: this.get(Role.GRID_LINE_FILL_COLOR),
                                width: this.get(Role.GRID_LINE_THICKNESS)
                            }
                        },
                        axisTick: {
                            length: this.get(Role.X_MAJOR_TICK_HEIGHT)
                        },
                        name: this.get(Role.X_AXIS_LABEL)
                    },
                    yAxis: this.current_y_axis,
                    series: this.series,
                    backgroundColor: this.get(Role.CHART_BACKGROUND),
                    visualMap: [{
                        show: false,
                        categories: ['0'],
                        dimension: 2,
                        outOfRange: {
                            symbolSize: 20,
                            symbol: 'circle',
                            color: this.get(Role.CHART_BACKGROUND)
                        }
                    }
                    ],
                    animation: false,
                    silent: false
                };
            }
        });
    });
