define(['core/adapters/SchemeAdapter',
'core/adapters/MasterPLCAdapter',
'core/adapters/ActionAdapter',
'core/adapters/StaticValueAdapter',
'core/adapters/ConditionAdapter',
'core/adapters/EventAdapter',
'core/adapters/SvgAdapter',
'core/adapters/FunctionBlockAdapter',
'core/adapters/ProtocolTaskAdapter',
'common/Enums'], function (
	SchemeAdapter,
	MasterPLCAdapter,
	ActionAdapter, 
	StaticValueAdapter,
    ConditionAdapter,
    EventAdapter,
    SvgAdapter,
    FunctionBlockAdapter,
    ProtocolTaskAdapter,
	enums) {

	function AdapterFactory() {

	};

	AdapterFactory.prototype.getByType = function(type) {
		switch(type) {
		    case enums.connectionType.client:
		        return SchemeAdapter;
		    case enums.connectionType.svg:
		        return SvgAdapter;
			case enums.connectionType.server:
				return MasterPLCAdapter;
		    case enums.connectionType.event:
		        return EventAdapter;
		    case enums.connectionType.action:
		        return ActionAdapter;
			case enums.connectionType.static:
		        return StaticValueAdapter;
		    case enums.connectionType.condition:
		        return ConditionAdapter;
		    case enums.connectionType.functionBlock:
		        return FunctionBlockAdapter;
		    case enums.connectionType.protocolTask:
                return ProtocolTaskAdapter;
            default:
                return SchemeAdapter;
		}
	};

	var instance = new AdapterFactory();
	return instance;
})