﻿// <copyright file="BaseFunctionBlock.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// 


define(['common/Enums', 'base/EventTarget', 'common/Error', 'core/functionBlocks/TaskList',
    'core/functionBlocks/ST/TaskWrapper', 'core/global/GlobalSettings'],
    function (Enums, EventTarget, Error, TaskList, TaskWrapper, GlobalSettings) {

        var TaskManager = Class.extend({          
            taskPath: '/scripts/core/functionBlocks/ST/tasks/',
            init: function () {               
                this.eventTarget = new EventTarget();
                this.tasks = {}; //{name: TaskWrapper}
                this.defaultTaskName = undefined;              
                this._addTasks();
            },

            _addTasks: function () {
                TaskList.forEach(function (taskDesc) {
                    if (this.tasks[taskDesc.name] !== undefined) {
                        Error.warn(String.format('Task {0} has been already added.'), taskDesc.name);
                        return;
                    }

                    this.tasks[taskDesc.name] = this._createTask(taskDesc);
                    this.defaultTaskName = taskDesc.name;
                }, this);
            },

            _createTask: function (taskDesc) {
                var task = new TaskWrapper({
                    name: taskDesc.name,
                    interval: taskDesc.interval,
                    fileName: this._getTaskFileName(taskDesc.name, taskDesc.type),
                    fbMetadata: taskDesc.functionBlocks
                });                

                return task;
            },                      

            _getTaskFileName: function (taskFileName, type) {
                var serverPrefix = GlobalSettings.get(Enums.ParameterRoles.REQUEST_SERVER_PREFIX);

                switch (type) {
                    case Enums.taskType.st:
                        return serverPrefix + this.taskPath + taskFileName + ".js";
                    default:
                        Error.onerror('Unsupported task type ' + type);
                        break;
                }
            },

            start: function () {
                for(task in this.tasks){                
                    this.tasks[task].start();
                }
            },

            //пока задача только одна
            getTask: function () {              
                return this.tasks[this.defaultTaskName];
            },

            getTasksCount: function () {
                return this.tasks[this.defaultTaskName] != undefined ? 1: 0;
            },
                      
            subscribePropertyChanged: function (handler, context) {
                this.tasks[this.defaultTaskName].subscribeTaskPropertyChanged(handler, context);
            },

            unsubscribePropertyChanged: function (handler) {
                this.tasks[this.defaultTaskName].unsubscribeTaskPropertyChanged(handler);
            },           

            subscribeTaskExecuted: function (handler, context) {
                this.tasks[this.defaultTaskName].subscribeTaskExecuted(handler, context);                
            },

            subscribeSubscribeTaskExecutedOnce: function (handler, context) {
                this.tasks[this.defaultTaskName].subscribeSubscribeTaskExecutedOnce(handler, context);
            },

            unsubscribeTaskExecuted: function (handler) {
                this.tasks[this.defaultTaskName].unsubscribeTaskExecuted(handler);
            },
        });

        return new TaskManager();
    });