﻿// <copyright file="TaskTimer.js" company="ИнСАТ">
// ИнСАТ, 2014
// </copyright>
// 

define(['core/Timer', 'common/Error'],
    function (Timer, Error) {

        var TaskTimer = Timer.extend({
            init: function (interval) {
                this._super(interval);
                this.promise = null;
                this.clearPromiseBind = this._clearPromise.bind(this);
            },

            _clearPromise: function () {
                this.promise = null;
            },

            getPromise: function () {
                return this.promise;
            },

            getActions: function () {
                if (this.started) {
                    if (this.actions.length > 0) {
                        try {
                            var startIndex;
                            if (this.promise !== null) {
                                startIndex = 0;
                            } else {
                                this.promise = this.actions[0]();
                                startIndex = 1;
                            }
                            
                            for (var i = startIndex; i < this.actions.length; i++) {
                                this.promise = this.promise.then(this.actions[i], this.actions[i]);
                            }

                            this.promise.then(this.refreshFunc, this.refreshFunc);
                        } catch (e) {
                            this.promise = null;
                            Error.exception(e);
                            this.refreshFunc();
                        }
                    } else {
                        this.refreshFunc();
                    }
                }
            },
        });

        return TaskTimer;
    });